/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.margin.schedule.StandardizedSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StandardizedScheduleValidCurrency")
@ImplementedBy(value=Default.class)
public interface StandardizedScheduleValidCurrency
extends Validator<StandardizedSchedule> {
    public static final String NAME = "StandardizedScheduleValidCurrency";
    public static final String DEFINITION = "notionalCurrency to-enum ISOCurrencyCodeEnum exists";

    public static class NoOp
    implements StandardizedScheduleValidCurrency {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedSchedule standardizedSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StandardizedScheduleValidCurrency {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedSchedule standardizedSchedule) {
            ComparisonResult result = this.executeDataRule(standardizedSchedule);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StandardizedScheduleValidCurrency.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedSchedule", (RosettaPath)path, (String)StandardizedScheduleValidCurrency.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StandardizedScheduleValidCurrency.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedSchedule", (RosettaPath)path, (String)StandardizedScheduleValidCurrency.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StandardizedSchedule standardizedSchedule) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)standardizedSchedule).map("getNotionalCurrency", _standardizedSchedule -> _standardizedSchedule.getNotionalCurrency()).checkedMap("to-enum", ISOCurrencyCodeEnum::fromDisplayName, IllegalArgumentException.class));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

