/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.event.common.Trade;
import cdm.margin.schedule.functions.AdjustableDateResolution;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import cdm.product.template.util.ProductDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import javax.inject.Inject;

@ImplementedBy(value=AuxiliarEffectiveDateDefault.class)
public abstract class AuxiliarEffectiveDate
implements RosettaFunction {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected ProductDeepPathUtil productDeepPathUtil;

    public Date evaluate(Trade trade) {
        Date effectiveDate = this.doEvaluate(trade);
        return effectiveDate;
    }

    protected abstract Date doEvaluate(Trade var1);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1);

    public static class AuxiliarEffectiveDateDefault
    extends AuxiliarEffectiveDate {
        @Override
        protected Date doEvaluate(Trade trade) {
            Date effectiveDate = null;
            return this.assignOutput(effectiveDate, trade);
        }

        protected Date assignOutput(Date effectiveDate, Trade trade) {
            if (ExpressionOperators.exists((Mapper)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                effectiveDate = (Date)thenArg0.min().get();
            } else if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((OptionPayout)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg1 = MapperS.of((Object)((OptionPayout)this.economicTerms(trade).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                effectiveDate = (Date)thenArg1.min().get();
            } else {
                effectiveDate = null;
            }
            return effectiveDate;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade) {
            return this.product(trade).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }
    }
}

