/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.transaction.additionalterms;

import cdm.legaldocumentation.transaction.Clause;
import cdm.legaldocumentation.transaction.additionalterms.meta.RepresentationsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Representations", builder=RepresentationsBuilderImpl.class, version="6.10.0")
@RuneDataType(value="Representations", model="cdm", builder=RepresentationsBuilderImpl.class, version="6.10.0")
public interface Representations
extends RosettaModelObject {
    public static final RepresentationsMeta metaData = new RepresentationsMeta();

    public Boolean getNonReliance();

    public Boolean getAgreementsRegardingHedging();

    public Boolean getIndexDisclaimer();

    public Boolean getAdditionalAcknowledgements();

    public List<? extends Clause> getAdditionalBespokeTerms();

    public Representations build();

    public RepresentationsBuilder toBuilder();

    public static RepresentationsBuilder builder() {
        return new RepresentationsBuilderImpl();
    }

    default public RosettaMetaData<? extends Representations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Representations> getType() {
        return Representations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("nonReliance"), Boolean.class, (Object)this.getNonReliance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("agreementsRegardingHedging"), Boolean.class, (Object)this.getAgreementsRegardingHedging(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexDisclaimer"), Boolean.class, (Object)this.getIndexDisclaimer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalAcknowledgements"), Boolean.class, (Object)this.getAdditionalAcknowledgements(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalBespokeTerms"), processor, Clause.class, this.getAdditionalBespokeTerms(), new AttributeMeta[0]);
    }

    public static class RepresentationsBuilderImpl
    implements RepresentationsBuilder {
        protected Boolean nonReliance;
        protected Boolean agreementsRegardingHedging;
        protected Boolean indexDisclaimer;
        protected Boolean additionalAcknowledgements;
        protected List<Clause.ClauseBuilder> additionalBespokeTerms = new ArrayList<Clause.ClauseBuilder>();

        @Override
        @RosettaAttribute(value="nonReliance", isRequired=true)
        @RuneAttribute(value="nonReliance", isRequired=true)
        public Boolean getNonReliance() {
            return this.nonReliance;
        }

        @Override
        @RosettaAttribute(value="agreementsRegardingHedging", isRequired=true)
        @RuneAttribute(value="agreementsRegardingHedging", isRequired=true)
        public Boolean getAgreementsRegardingHedging() {
            return this.agreementsRegardingHedging;
        }

        @Override
        @RosettaAttribute(value="indexDisclaimer")
        @RuneAttribute(value="indexDisclaimer")
        public Boolean getIndexDisclaimer() {
            return this.indexDisclaimer;
        }

        @Override
        @RosettaAttribute(value="additionalAcknowledgements")
        @RuneAttribute(value="additionalAcknowledgements")
        public Boolean getAdditionalAcknowledgements() {
            return this.additionalAcknowledgements;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public List<? extends Clause.ClauseBuilder> getAdditionalBespokeTerms() {
            return this.additionalBespokeTerms;
        }

        @Override
        public Clause.ClauseBuilder getOrCreateAdditionalBespokeTerms(int index) {
            if (this.additionalBespokeTerms == null) {
                this.additionalBespokeTerms = new ArrayList<Clause.ClauseBuilder>();
            }
            return (Clause.ClauseBuilder)this.getIndex(this.additionalBespokeTerms, index, () -> {
                Clause.ClauseBuilder newAdditionalBespokeTerms = Clause.builder();
                return newAdditionalBespokeTerms;
            });
        }

        @Override
        @RosettaAttribute(value="nonReliance", isRequired=true)
        @RuneAttribute(value="nonReliance", isRequired=true)
        public RepresentationsBuilder setNonReliance(Boolean _nonReliance) {
            this.nonReliance = _nonReliance == null ? null : _nonReliance;
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementsRegardingHedging", isRequired=true)
        @RuneAttribute(value="agreementsRegardingHedging", isRequired=true)
        public RepresentationsBuilder setAgreementsRegardingHedging(Boolean _agreementsRegardingHedging) {
            this.agreementsRegardingHedging = _agreementsRegardingHedging == null ? null : _agreementsRegardingHedging;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexDisclaimer")
        @RuneAttribute(value="indexDisclaimer")
        public RepresentationsBuilder setIndexDisclaimer(Boolean _indexDisclaimer) {
            this.indexDisclaimer = _indexDisclaimer == null ? null : _indexDisclaimer;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalAcknowledgements")
        @RuneAttribute(value="additionalAcknowledgements")
        public RepresentationsBuilder setAdditionalAcknowledgements(Boolean _additionalAcknowledgements) {
            this.additionalAcknowledgements = _additionalAcknowledgements == null ? null : _additionalAcknowledgements;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public RepresentationsBuilder addAdditionalBespokeTerms(Clause _additionalBespokeTerms) {
            if (_additionalBespokeTerms != null) {
                this.additionalBespokeTerms.add(_additionalBespokeTerms.toBuilder());
            }
            return this;
        }

        @Override
        public RepresentationsBuilder addAdditionalBespokeTerms(Clause _additionalBespokeTerms, int idx) {
            this.getIndex(this.additionalBespokeTerms, idx, () -> _additionalBespokeTerms.toBuilder());
            return this;
        }

        @Override
        public RepresentationsBuilder addAdditionalBespokeTerms(List<? extends Clause> additionalBespokeTermss) {
            if (additionalBespokeTermss != null) {
                for (Clause clause : additionalBespokeTermss) {
                    this.additionalBespokeTerms.add(clause.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalBespokeTerms")
        public RepresentationsBuilder setAdditionalBespokeTerms(List<? extends Clause> additionalBespokeTermss) {
            this.additionalBespokeTerms = additionalBespokeTermss == null ? new ArrayList<Clause.ClauseBuilder>() : (List)additionalBespokeTermss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Representations build() {
            return new RepresentationsImpl(this);
        }

        @Override
        public RepresentationsBuilder toBuilder() {
            return this;
        }

        @Override
        public RepresentationsBuilder prune() {
            this.additionalBespokeTerms = this.additionalBespokeTerms.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNonReliance() != null) {
                return true;
            }
            if (this.getAgreementsRegardingHedging() != null) {
                return true;
            }
            if (this.getIndexDisclaimer() != null) {
                return true;
            }
            if (this.getAdditionalAcknowledgements() != null) {
                return true;
            }
            return this.getAdditionalBespokeTerms() != null && this.getAdditionalBespokeTerms().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RepresentationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepresentationsBuilder o = (RepresentationsBuilder)other;
            merger.mergeRosetta(this.getAdditionalBespokeTerms(), o.getAdditionalBespokeTerms(), this::getOrCreateAdditionalBespokeTerms);
            merger.mergeBasic((Object)this.getNonReliance(), (Object)o.getNonReliance(), this::setNonReliance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAgreementsRegardingHedging(), (Object)o.getAgreementsRegardingHedging(), this::setAgreementsRegardingHedging, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexDisclaimer(), (Object)o.getIndexDisclaimer(), this::setIndexDisclaimer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalAcknowledgements(), (Object)o.getAdditionalAcknowledgements(), this::setAdditionalAcknowledgements, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Representations _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReliance, _that.getNonReliance())) {
                return false;
            }
            if (!Objects.equals(this.agreementsRegardingHedging, _that.getAgreementsRegardingHedging())) {
                return false;
            }
            if (!Objects.equals(this.indexDisclaimer, _that.getIndexDisclaimer())) {
                return false;
            }
            if (!Objects.equals(this.additionalAcknowledgements, _that.getAdditionalAcknowledgements())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalBespokeTerms, _that.getAdditionalBespokeTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReliance != null ? this.nonReliance.hashCode() : 0);
            _result = 31 * _result + (this.agreementsRegardingHedging != null ? this.agreementsRegardingHedging.hashCode() : 0);
            _result = 31 * _result + (this.indexDisclaimer != null ? this.indexDisclaimer.hashCode() : 0);
            _result = 31 * _result + (this.additionalAcknowledgements != null ? this.additionalAcknowledgements.hashCode() : 0);
            _result = 31 * _result + (this.additionalBespokeTerms != null ? this.additionalBespokeTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepresentationsBuilder {nonReliance=" + this.nonReliance + ", agreementsRegardingHedging=" + this.agreementsRegardingHedging + ", indexDisclaimer=" + this.indexDisclaimer + ", additionalAcknowledgements=" + this.additionalAcknowledgements + ", additionalBespokeTerms=" + this.additionalBespokeTerms + '}';
        }
    }

    public static interface RepresentationsBuilder
    extends Representations,
    RosettaModelObjectBuilder {
        public Clause.ClauseBuilder getOrCreateAdditionalBespokeTerms(int var1);

        public List<? extends Clause.ClauseBuilder> getAdditionalBespokeTerms();

        public RepresentationsBuilder setNonReliance(Boolean var1);

        public RepresentationsBuilder setAgreementsRegardingHedging(Boolean var1);

        public RepresentationsBuilder setIndexDisclaimer(Boolean var1);

        public RepresentationsBuilder setAdditionalAcknowledgements(Boolean var1);

        public RepresentationsBuilder addAdditionalBespokeTerms(Clause var1);

        public RepresentationsBuilder addAdditionalBespokeTerms(Clause var1, int var2);

        public RepresentationsBuilder addAdditionalBespokeTerms(List<? extends Clause> var1);

        public RepresentationsBuilder setAdditionalBespokeTerms(List<? extends Clause> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("nonReliance"), Boolean.class, (Object)this.getNonReliance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("agreementsRegardingHedging"), Boolean.class, (Object)this.getAgreementsRegardingHedging(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexDisclaimer"), Boolean.class, (Object)this.getIndexDisclaimer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalAcknowledgements"), Boolean.class, (Object)this.getAdditionalAcknowledgements(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalBespokeTerms"), processor, Clause.ClauseBuilder.class, this.getAdditionalBespokeTerms(), new AttributeMeta[0]);
        }

        public RepresentationsBuilder prune();
    }

    public static class RepresentationsImpl
    implements Representations {
        private final Boolean nonReliance;
        private final Boolean agreementsRegardingHedging;
        private final Boolean indexDisclaimer;
        private final Boolean additionalAcknowledgements;
        private final List<? extends Clause> additionalBespokeTerms;

        protected RepresentationsImpl(RepresentationsBuilder builder) {
            this.nonReliance = builder.getNonReliance();
            this.agreementsRegardingHedging = builder.getAgreementsRegardingHedging();
            this.indexDisclaimer = builder.getIndexDisclaimer();
            this.additionalAcknowledgements = builder.getAdditionalAcknowledgements();
            this.additionalBespokeTerms = Optional.ofNullable(builder.getAdditionalBespokeTerms()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="nonReliance", isRequired=true)
        @RuneAttribute(value="nonReliance", isRequired=true)
        public Boolean getNonReliance() {
            return this.nonReliance;
        }

        @Override
        @RosettaAttribute(value="agreementsRegardingHedging", isRequired=true)
        @RuneAttribute(value="agreementsRegardingHedging", isRequired=true)
        public Boolean getAgreementsRegardingHedging() {
            return this.agreementsRegardingHedging;
        }

        @Override
        @RosettaAttribute(value="indexDisclaimer")
        @RuneAttribute(value="indexDisclaimer")
        public Boolean getIndexDisclaimer() {
            return this.indexDisclaimer;
        }

        @Override
        @RosettaAttribute(value="additionalAcknowledgements")
        @RuneAttribute(value="additionalAcknowledgements")
        public Boolean getAdditionalAcknowledgements() {
            return this.additionalAcknowledgements;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public List<? extends Clause> getAdditionalBespokeTerms() {
            return this.additionalBespokeTerms;
        }

        @Override
        public Representations build() {
            return this;
        }

        @Override
        public RepresentationsBuilder toBuilder() {
            RepresentationsBuilder builder = Representations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepresentationsBuilder builder) {
            Optional.ofNullable(this.getNonReliance()).ifPresent(builder::setNonReliance);
            Optional.ofNullable(this.getAgreementsRegardingHedging()).ifPresent(builder::setAgreementsRegardingHedging);
            Optional.ofNullable(this.getIndexDisclaimer()).ifPresent(builder::setIndexDisclaimer);
            Optional.ofNullable(this.getAdditionalAcknowledgements()).ifPresent(builder::setAdditionalAcknowledgements);
            Optional.ofNullable(this.getAdditionalBespokeTerms()).ifPresent(builder::setAdditionalBespokeTerms);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Representations _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReliance, _that.getNonReliance())) {
                return false;
            }
            if (!Objects.equals(this.agreementsRegardingHedging, _that.getAgreementsRegardingHedging())) {
                return false;
            }
            if (!Objects.equals(this.indexDisclaimer, _that.getIndexDisclaimer())) {
                return false;
            }
            if (!Objects.equals(this.additionalAcknowledgements, _that.getAdditionalAcknowledgements())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalBespokeTerms, _that.getAdditionalBespokeTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReliance != null ? this.nonReliance.hashCode() : 0);
            _result = 31 * _result + (this.agreementsRegardingHedging != null ? this.agreementsRegardingHedging.hashCode() : 0);
            _result = 31 * _result + (this.indexDisclaimer != null ? this.indexDisclaimer.hashCode() : 0);
            _result = 31 * _result + (this.additionalAcknowledgements != null ? this.additionalAcknowledgements.hashCode() : 0);
            _result = 31 * _result + (this.additionalBespokeTerms != null ? this.additionalBespokeTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Representations {nonReliance=" + this.nonReliance + ", agreementsRegardingHedging=" + this.agreementsRegardingHedging + ", indexDisclaimer=" + this.indexDisclaimer + ", additionalAcknowledgements=" + this.additionalAcknowledgements + ", additionalBespokeTerms=" + this.additionalBespokeTerms + '}';
        }
    }
}

