/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master.isda.validation.datarule;

import cdm.legaldocumentation.master.isda.AutomaticEarlyTermination;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AutomaticEarlyTerminationFallbackAET")
@ImplementedBy(value=Default.class)
public interface AutomaticEarlyTerminationFallbackAET
extends Validator<AutomaticEarlyTermination> {
    public static final String NAME = "AutomaticEarlyTerminationFallbackAET";
    public static final String DEFINITION = "if fallbackAET = True then partyElection -> isApplicable all = False";

    public static class NoOp
    implements AutomaticEarlyTerminationFallbackAET {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AutomaticEarlyTermination automaticEarlyTermination) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AutomaticEarlyTerminationFallbackAET {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AutomaticEarlyTermination automaticEarlyTermination) {
            ComparisonResult result = this.executeDataRule(automaticEarlyTermination);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AutomaticEarlyTerminationFallbackAET.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AutomaticEarlyTermination", (RosettaPath)path, (String)AutomaticEarlyTerminationFallbackAET.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AutomaticEarlyTerminationFallbackAET.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AutomaticEarlyTermination", (RosettaPath)path, (String)AutomaticEarlyTerminationFallbackAET.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AutomaticEarlyTermination automaticEarlyTermination) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)automaticEarlyTermination).map("getFallbackAET", _automaticEarlyTermination -> _automaticEarlyTermination.getFallbackAET()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)automaticEarlyTermination).mapC("getPartyElection", _automaticEarlyTermination -> _automaticEarlyTermination.getPartyElection()).map("getIsApplicable", automaticEarlyTerminationElection -> automaticEarlyTerminationElection.getIsApplicable()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

