/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master.isda;

import cdm.legaldocumentation.master.isda.PartyTerminationCurrencySelection;
import cdm.legaldocumentation.master.isda.meta.TerminationCurrencySelectionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TerminationCurrencySelection", builder=TerminationCurrencySelectionBuilderImpl.class, version="6.10.0")
@RuneDataType(value="TerminationCurrencySelection", model="cdm", builder=TerminationCurrencySelectionBuilderImpl.class, version="6.10.0")
public interface TerminationCurrencySelection
extends RosettaModelObject {
    public static final TerminationCurrencySelectionMeta metaData = new TerminationCurrencySelectionMeta();

    public String getStatedCurrency();

    public String getFallbackCurrency();

    public List<? extends PartyTerminationCurrencySelection> getPartyElection();

    public String getBothAffected();

    public TerminationCurrencySelection build();

    public TerminationCurrencySelectionBuilder toBuilder();

    public static TerminationCurrencySelectionBuilder builder() {
        return new TerminationCurrencySelectionBuilderImpl();
    }

    default public RosettaMetaData<? extends TerminationCurrencySelection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TerminationCurrencySelection> getType() {
        return TerminationCurrencySelection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("statedCurrency"), String.class, (Object)this.getStatedCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fallbackCurrency"), String.class, (Object)this.getFallbackCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyElection"), processor, PartyTerminationCurrencySelection.class, this.getPartyElection(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bothAffected"), String.class, (Object)this.getBothAffected(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TerminationCurrencySelectionBuilderImpl
    implements TerminationCurrencySelectionBuilder {
        protected String statedCurrency;
        protected String fallbackCurrency;
        protected List<PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder> partyElection = new ArrayList<PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder>();
        protected String bothAffected;

        @Override
        @RosettaAttribute(value="statedCurrency")
        @RuneAttribute(value="statedCurrency")
        public String getStatedCurrency() {
            return this.statedCurrency;
        }

        @Override
        @RosettaAttribute(value="fallbackCurrency")
        @RuneAttribute(value="fallbackCurrency")
        public String getFallbackCurrency() {
            return this.fallbackCurrency;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public List<? extends PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder> getPartyElection() {
            return this.partyElection;
        }

        @Override
        public PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder getOrCreatePartyElection(int index) {
            if (this.partyElection == null) {
                this.partyElection = new ArrayList<PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder>();
            }
            return (PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder)this.getIndex(this.partyElection, index, () -> {
                PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder newPartyElection = PartyTerminationCurrencySelection.builder();
                return newPartyElection;
            });
        }

        @Override
        @RosettaAttribute(value="bothAffected")
        @RuneAttribute(value="bothAffected")
        public String getBothAffected() {
            return this.bothAffected;
        }

        @Override
        @RosettaAttribute(value="statedCurrency")
        @RuneAttribute(value="statedCurrency")
        public TerminationCurrencySelectionBuilder setStatedCurrency(String _statedCurrency) {
            this.statedCurrency = _statedCurrency == null ? null : _statedCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackCurrency")
        @RuneAttribute(value="fallbackCurrency")
        public TerminationCurrencySelectionBuilder setFallbackCurrency(String _fallbackCurrency) {
            this.fallbackCurrency = _fallbackCurrency == null ? null : _fallbackCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public TerminationCurrencySelectionBuilder addPartyElection(PartyTerminationCurrencySelection _partyElection) {
            if (_partyElection != null) {
                this.partyElection.add(_partyElection.toBuilder());
            }
            return this;
        }

        @Override
        public TerminationCurrencySelectionBuilder addPartyElection(PartyTerminationCurrencySelection _partyElection, int idx) {
            this.getIndex(this.partyElection, idx, () -> _partyElection.toBuilder());
            return this;
        }

        @Override
        public TerminationCurrencySelectionBuilder addPartyElection(List<? extends PartyTerminationCurrencySelection> partyElections) {
            if (partyElections != null) {
                for (PartyTerminationCurrencySelection partyTerminationCurrencySelection : partyElections) {
                    this.partyElection.add(partyTerminationCurrencySelection.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyElection")
        public TerminationCurrencySelectionBuilder setPartyElection(List<? extends PartyTerminationCurrencySelection> partyElections) {
            this.partyElection = partyElections == null ? new ArrayList<PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder>() : (List)partyElections.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="bothAffected")
        @RuneAttribute(value="bothAffected")
        public TerminationCurrencySelectionBuilder setBothAffected(String _bothAffected) {
            this.bothAffected = _bothAffected == null ? null : _bothAffected;
            return this;
        }

        @Override
        public TerminationCurrencySelection build() {
            return new TerminationCurrencySelectionImpl(this);
        }

        @Override
        public TerminationCurrencySelectionBuilder toBuilder() {
            return this;
        }

        @Override
        public TerminationCurrencySelectionBuilder prune() {
            this.partyElection = this.partyElection.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getStatedCurrency() != null) {
                return true;
            }
            if (this.getFallbackCurrency() != null) {
                return true;
            }
            if (this.getPartyElection() != null && this.getPartyElection().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBothAffected() != null;
        }

        public TerminationCurrencySelectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TerminationCurrencySelectionBuilder o = (TerminationCurrencySelectionBuilder)other;
            merger.mergeRosetta(this.getPartyElection(), o.getPartyElection(), this::getOrCreatePartyElection);
            merger.mergeBasic((Object)this.getStatedCurrency(), (Object)o.getStatedCurrency(), this::setStatedCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFallbackCurrency(), (Object)o.getFallbackCurrency(), this::setFallbackCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBothAffected(), (Object)o.getBothAffected(), this::setBothAffected, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TerminationCurrencySelection _that = this.getType().cast(o);
            if (!Objects.equals(this.statedCurrency, _that.getStatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fallbackCurrency, _that.getFallbackCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyElection, _that.getPartyElection())) {
                return false;
            }
            return Objects.equals(this.bothAffected, _that.getBothAffected());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.statedCurrency != null ? this.statedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fallbackCurrency != null ? this.fallbackCurrency.hashCode() : 0);
            _result = 31 * _result + (this.partyElection != null ? this.partyElection.hashCode() : 0);
            _result = 31 * _result + (this.bothAffected != null ? this.bothAffected.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TerminationCurrencySelectionBuilder {statedCurrency=" + this.statedCurrency + ", fallbackCurrency=" + this.fallbackCurrency + ", partyElection=" + this.partyElection + ", bothAffected=" + this.bothAffected + '}';
        }
    }

    public static interface TerminationCurrencySelectionBuilder
    extends TerminationCurrencySelection,
    RosettaModelObjectBuilder {
        public PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder getOrCreatePartyElection(int var1);

        public List<? extends PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder> getPartyElection();

        public TerminationCurrencySelectionBuilder setStatedCurrency(String var1);

        public TerminationCurrencySelectionBuilder setFallbackCurrency(String var1);

        public TerminationCurrencySelectionBuilder addPartyElection(PartyTerminationCurrencySelection var1);

        public TerminationCurrencySelectionBuilder addPartyElection(PartyTerminationCurrencySelection var1, int var2);

        public TerminationCurrencySelectionBuilder addPartyElection(List<? extends PartyTerminationCurrencySelection> var1);

        public TerminationCurrencySelectionBuilder setPartyElection(List<? extends PartyTerminationCurrencySelection> var1);

        public TerminationCurrencySelectionBuilder setBothAffected(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("statedCurrency"), String.class, (Object)this.getStatedCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fallbackCurrency"), String.class, (Object)this.getFallbackCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyElection"), processor, PartyTerminationCurrencySelection.PartyTerminationCurrencySelectionBuilder.class, this.getPartyElection(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bothAffected"), String.class, (Object)this.getBothAffected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TerminationCurrencySelectionBuilder prune();
    }

    public static class TerminationCurrencySelectionImpl
    implements TerminationCurrencySelection {
        private final String statedCurrency;
        private final String fallbackCurrency;
        private final List<? extends PartyTerminationCurrencySelection> partyElection;
        private final String bothAffected;

        protected TerminationCurrencySelectionImpl(TerminationCurrencySelectionBuilder builder) {
            this.statedCurrency = builder.getStatedCurrency();
            this.fallbackCurrency = builder.getFallbackCurrency();
            this.partyElection = Optional.ofNullable(builder.getPartyElection()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.bothAffected = builder.getBothAffected();
        }

        @Override
        @RosettaAttribute(value="statedCurrency")
        @RuneAttribute(value="statedCurrency")
        public String getStatedCurrency() {
            return this.statedCurrency;
        }

        @Override
        @RosettaAttribute(value="fallbackCurrency")
        @RuneAttribute(value="fallbackCurrency")
        public String getFallbackCurrency() {
            return this.fallbackCurrency;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public List<? extends PartyTerminationCurrencySelection> getPartyElection() {
            return this.partyElection;
        }

        @Override
        @RosettaAttribute(value="bothAffected")
        @RuneAttribute(value="bothAffected")
        public String getBothAffected() {
            return this.bothAffected;
        }

        @Override
        public TerminationCurrencySelection build() {
            return this;
        }

        @Override
        public TerminationCurrencySelectionBuilder toBuilder() {
            TerminationCurrencySelectionBuilder builder = TerminationCurrencySelection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TerminationCurrencySelectionBuilder builder) {
            Optional.ofNullable(this.getStatedCurrency()).ifPresent(builder::setStatedCurrency);
            Optional.ofNullable(this.getFallbackCurrency()).ifPresent(builder::setFallbackCurrency);
            Optional.ofNullable(this.getPartyElection()).ifPresent(builder::setPartyElection);
            Optional.ofNullable(this.getBothAffected()).ifPresent(builder::setBothAffected);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TerminationCurrencySelection _that = this.getType().cast(o);
            if (!Objects.equals(this.statedCurrency, _that.getStatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fallbackCurrency, _that.getFallbackCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyElection, _that.getPartyElection())) {
                return false;
            }
            return Objects.equals(this.bothAffected, _that.getBothAffected());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.statedCurrency != null ? this.statedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fallbackCurrency != null ? this.fallbackCurrency.hashCode() : 0);
            _result = 31 * _result + (this.partyElection != null ? this.partyElection.hashCode() : 0);
            _result = 31 * _result + (this.bothAffected != null ? this.bothAffected.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TerminationCurrencySelection {statedCurrency=" + this.statedCurrency + ", fallbackCurrency=" + this.fallbackCurrency + ", partyElection=" + this.partyElection + ", bothAffected=" + this.bothAffected + '}';
        }
    }
}

