/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master.isda;

import cdm.base.staticdata.party.LegalEntity;
import cdm.base.staticdata.party.Party;
import cdm.legaldocumentation.common.SpecifiedEntityTermsEnum;
import cdm.legaldocumentation.master.isda.meta.SpecifiedEntityMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SpecifiedEntity", builder=SpecifiedEntityBuilderImpl.class, version="6.10.0")
@RuneDataType(value="SpecifiedEntity", model="cdm", builder=SpecifiedEntityBuilderImpl.class, version="6.10.0")
public interface SpecifiedEntity
extends RosettaModelObject {
    public static final SpecifiedEntityMeta metaData = new SpecifiedEntityMeta();

    public Party getParty();

    public SpecifiedEntityTermsEnum getSpecifiedEntityTerms();

    public List<? extends LegalEntity> getSpecifiedEntity();

    public String getMaterialSubsidiaryTerms();

    public String getOtherSpecifiedEntityTerms();

    public SpecifiedEntity build();

    public SpecifiedEntityBuilder toBuilder();

    public static SpecifiedEntityBuilder builder() {
        return new SpecifiedEntityBuilderImpl();
    }

    default public RosettaMetaData<? extends SpecifiedEntity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SpecifiedEntity> getType() {
        return SpecifiedEntity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedEntityTerms"), SpecifiedEntityTermsEnum.class, (Object)this.getSpecifiedEntityTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedEntity"), processor, LegalEntity.class, this.getSpecifiedEntity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("materialSubsidiaryTerms"), String.class, (Object)this.getMaterialSubsidiaryTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherSpecifiedEntityTerms"), String.class, (Object)this.getOtherSpecifiedEntityTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SpecifiedEntityBuilderImpl
    implements SpecifiedEntityBuilder {
        protected Party.PartyBuilder party;
        protected SpecifiedEntityTermsEnum specifiedEntityTerms;
        protected List<LegalEntity.LegalEntityBuilder> specifiedEntity = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected String materialSubsidiaryTerms;
        protected String otherSpecifiedEntityTerms;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party.PartyBuilder getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty() {
            Party.PartyBuilder result = this.party != null ? this.party : (this.party = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="specifiedEntityTerms", isRequired=true)
        @RuneAttribute(value="specifiedEntityTerms", isRequired=true)
        public SpecifiedEntityTermsEnum getSpecifiedEntityTerms() {
            return this.specifiedEntityTerms;
        }

        @Override
        @RosettaAttribute(value="specifiedEntity")
        @RuneAttribute(value="specifiedEntity")
        public List<? extends LegalEntity.LegalEntityBuilder> getSpecifiedEntity() {
            return this.specifiedEntity;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateSpecifiedEntity(int index) {
            if (this.specifiedEntity == null) {
                this.specifiedEntity = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.specifiedEntity, index, () -> {
                LegalEntity.LegalEntityBuilder newSpecifiedEntity = LegalEntity.builder();
                return newSpecifiedEntity;
            });
        }

        @Override
        @RosettaAttribute(value="materialSubsidiaryTerms")
        @RuneAttribute(value="materialSubsidiaryTerms")
        public String getMaterialSubsidiaryTerms() {
            return this.materialSubsidiaryTerms;
        }

        @Override
        @RosettaAttribute(value="otherSpecifiedEntityTerms")
        @RuneAttribute(value="otherSpecifiedEntityTerms")
        public String getOtherSpecifiedEntityTerms() {
            return this.otherSpecifiedEntityTerms;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public SpecifiedEntityBuilder setParty(Party _party) {
            this.party = _party == null ? null : _party.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedEntityTerms", isRequired=true)
        @RuneAttribute(value="specifiedEntityTerms", isRequired=true)
        public SpecifiedEntityBuilder setSpecifiedEntityTerms(SpecifiedEntityTermsEnum _specifiedEntityTerms) {
            this.specifiedEntityTerms = _specifiedEntityTerms == null ? null : _specifiedEntityTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedEntity")
        @RuneAttribute(value="specifiedEntity")
        public SpecifiedEntityBuilder addSpecifiedEntity(LegalEntity _specifiedEntity) {
            if (_specifiedEntity != null) {
                this.specifiedEntity.add(_specifiedEntity.toBuilder());
            }
            return this;
        }

        @Override
        public SpecifiedEntityBuilder addSpecifiedEntity(LegalEntity _specifiedEntity, int idx) {
            this.getIndex(this.specifiedEntity, idx, () -> _specifiedEntity.toBuilder());
            return this;
        }

        @Override
        public SpecifiedEntityBuilder addSpecifiedEntity(List<? extends LegalEntity> specifiedEntitys) {
            if (specifiedEntitys != null) {
                for (LegalEntity legalEntity : specifiedEntitys) {
                    this.specifiedEntity.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="specifiedEntity")
        public SpecifiedEntityBuilder setSpecifiedEntity(List<? extends LegalEntity> specifiedEntitys) {
            this.specifiedEntity = specifiedEntitys == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)specifiedEntitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="materialSubsidiaryTerms")
        @RuneAttribute(value="materialSubsidiaryTerms")
        public SpecifiedEntityBuilder setMaterialSubsidiaryTerms(String _materialSubsidiaryTerms) {
            this.materialSubsidiaryTerms = _materialSubsidiaryTerms == null ? null : _materialSubsidiaryTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherSpecifiedEntityTerms")
        @RuneAttribute(value="otherSpecifiedEntityTerms")
        public SpecifiedEntityBuilder setOtherSpecifiedEntityTerms(String _otherSpecifiedEntityTerms) {
            this.otherSpecifiedEntityTerms = _otherSpecifiedEntityTerms == null ? null : _otherSpecifiedEntityTerms;
            return this;
        }

        @Override
        public SpecifiedEntity build() {
            return new SpecifiedEntityImpl(this);
        }

        @Override
        public SpecifiedEntityBuilder toBuilder() {
            return this;
        }

        @Override
        public SpecifiedEntityBuilder prune() {
            if (this.party != null && !this.party.prune().hasData()) {
                this.party = null;
            }
            this.specifiedEntity = this.specifiedEntity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null && this.getParty().hasData()) {
                return true;
            }
            if (this.getSpecifiedEntityTerms() != null) {
                return true;
            }
            if (this.getSpecifiedEntity() != null && this.getSpecifiedEntity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMaterialSubsidiaryTerms() != null) {
                return true;
            }
            return this.getOtherSpecifiedEntityTerms() != null;
        }

        public SpecifiedEntityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SpecifiedEntityBuilder o = (SpecifiedEntityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParty(), (RosettaModelObjectBuilder)o.getParty(), this::setParty);
            merger.mergeRosetta(this.getSpecifiedEntity(), o.getSpecifiedEntity(), this::getOrCreateSpecifiedEntity);
            merger.mergeBasic((Object)this.getSpecifiedEntityTerms(), (Object)o.getSpecifiedEntityTerms(), this::setSpecifiedEntityTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaterialSubsidiaryTerms(), (Object)o.getMaterialSubsidiaryTerms(), this::setMaterialSubsidiaryTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOtherSpecifiedEntityTerms(), (Object)o.getOtherSpecifiedEntityTerms(), this::setOtherSpecifiedEntityTerms, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.specifiedEntityTerms, (Object)_that.getSpecifiedEntityTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.specifiedEntity, _that.getSpecifiedEntity())) {
                return false;
            }
            if (!Objects.equals(this.materialSubsidiaryTerms, _that.getMaterialSubsidiaryTerms())) {
                return false;
            }
            return Objects.equals(this.otherSpecifiedEntityTerms, _that.getOtherSpecifiedEntityTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntityTerms != null ? ((Object)((Object)this.specifiedEntityTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntity != null ? this.specifiedEntity.hashCode() : 0);
            _result = 31 * _result + (this.materialSubsidiaryTerms != null ? this.materialSubsidiaryTerms.hashCode() : 0);
            _result = 31 * _result + (this.otherSpecifiedEntityTerms != null ? this.otherSpecifiedEntityTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedEntityBuilder {party=" + this.party + ", specifiedEntityTerms=" + (Object)((Object)this.specifiedEntityTerms) + ", specifiedEntity=" + this.specifiedEntity + ", materialSubsidiaryTerms=" + this.materialSubsidiaryTerms + ", otherSpecifiedEntityTerms=" + this.otherSpecifiedEntityTerms + '}';
        }
    }

    public static interface SpecifiedEntityBuilder
    extends SpecifiedEntity,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateParty();

        @Override
        public Party.PartyBuilder getParty();

        public LegalEntity.LegalEntityBuilder getOrCreateSpecifiedEntity(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getSpecifiedEntity();

        public SpecifiedEntityBuilder setParty(Party var1);

        public SpecifiedEntityBuilder setSpecifiedEntityTerms(SpecifiedEntityTermsEnum var1);

        public SpecifiedEntityBuilder addSpecifiedEntity(LegalEntity var1);

        public SpecifiedEntityBuilder addSpecifiedEntity(LegalEntity var1, int var2);

        public SpecifiedEntityBuilder addSpecifiedEntity(List<? extends LegalEntity> var1);

        public SpecifiedEntityBuilder setSpecifiedEntity(List<? extends LegalEntity> var1);

        public SpecifiedEntityBuilder setMaterialSubsidiaryTerms(String var1);

        public SpecifiedEntityBuilder setOtherSpecifiedEntityTerms(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedEntityTerms"), SpecifiedEntityTermsEnum.class, (Object)this.getSpecifiedEntityTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedEntity"), processor, LegalEntity.LegalEntityBuilder.class, this.getSpecifiedEntity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("materialSubsidiaryTerms"), String.class, (Object)this.getMaterialSubsidiaryTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherSpecifiedEntityTerms"), String.class, (Object)this.getOtherSpecifiedEntityTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SpecifiedEntityBuilder prune();
    }

    public static class SpecifiedEntityImpl
    implements SpecifiedEntity {
        private final Party party;
        private final SpecifiedEntityTermsEnum specifiedEntityTerms;
        private final List<? extends LegalEntity> specifiedEntity;
        private final String materialSubsidiaryTerms;
        private final String otherSpecifiedEntityTerms;

        protected SpecifiedEntityImpl(SpecifiedEntityBuilder builder) {
            this.party = Optional.ofNullable(builder.getParty()).map(f -> f.build()).orElse(null);
            this.specifiedEntityTerms = builder.getSpecifiedEntityTerms();
            this.specifiedEntity = Optional.ofNullable(builder.getSpecifiedEntity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.materialSubsidiaryTerms = builder.getMaterialSubsidiaryTerms();
            this.otherSpecifiedEntityTerms = builder.getOtherSpecifiedEntityTerms();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="specifiedEntityTerms", isRequired=true)
        @RuneAttribute(value="specifiedEntityTerms", isRequired=true)
        public SpecifiedEntityTermsEnum getSpecifiedEntityTerms() {
            return this.specifiedEntityTerms;
        }

        @Override
        @RosettaAttribute(value="specifiedEntity")
        @RuneAttribute(value="specifiedEntity")
        public List<? extends LegalEntity> getSpecifiedEntity() {
            return this.specifiedEntity;
        }

        @Override
        @RosettaAttribute(value="materialSubsidiaryTerms")
        @RuneAttribute(value="materialSubsidiaryTerms")
        public String getMaterialSubsidiaryTerms() {
            return this.materialSubsidiaryTerms;
        }

        @Override
        @RosettaAttribute(value="otherSpecifiedEntityTerms")
        @RuneAttribute(value="otherSpecifiedEntityTerms")
        public String getOtherSpecifiedEntityTerms() {
            return this.otherSpecifiedEntityTerms;
        }

        @Override
        public SpecifiedEntity build() {
            return this;
        }

        @Override
        public SpecifiedEntityBuilder toBuilder() {
            SpecifiedEntityBuilder builder = SpecifiedEntity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SpecifiedEntityBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getSpecifiedEntityTerms()).ifPresent(builder::setSpecifiedEntityTerms);
            Optional.ofNullable(this.getSpecifiedEntity()).ifPresent(builder::setSpecifiedEntity);
            Optional.ofNullable(this.getMaterialSubsidiaryTerms()).ifPresent(builder::setMaterialSubsidiaryTerms);
            Optional.ofNullable(this.getOtherSpecifiedEntityTerms()).ifPresent(builder::setOtherSpecifiedEntityTerms);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.specifiedEntityTerms, (Object)_that.getSpecifiedEntityTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.specifiedEntity, _that.getSpecifiedEntity())) {
                return false;
            }
            if (!Objects.equals(this.materialSubsidiaryTerms, _that.getMaterialSubsidiaryTerms())) {
                return false;
            }
            return Objects.equals(this.otherSpecifiedEntityTerms, _that.getOtherSpecifiedEntityTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntityTerms != null ? ((Object)((Object)this.specifiedEntityTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntity != null ? this.specifiedEntity.hashCode() : 0);
            _result = 31 * _result + (this.materialSubsidiaryTerms != null ? this.materialSubsidiaryTerms.hashCode() : 0);
            _result = 31 * _result + (this.otherSpecifiedEntityTerms != null ? this.otherSpecifiedEntityTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedEntity {party=" + this.party + ", specifiedEntityTerms=" + (Object)((Object)this.specifiedEntityTerms) + ", specifiedEntity=" + this.specifiedEntity + ", materialSubsidiaryTerms=" + this.materialSubsidiaryTerms + ", otherSpecifiedEntityTerms=" + this.otherSpecifiedEntityTerms + '}';
        }
    }
}

