/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.TerminationCurrencyAmendment;
import cdm.legaldocumentation.csa.TerminationCurrencyElection;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.isda.cdm.processor.CdmMappingProcessorUtils;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class TerminationCurrencyAmendmentMappingProcessor
extends MappingProcessor {
    public TerminationCurrencyAmendmentMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        List<Mapping> notApplicableSubMappings = this.anySubPathValueMatches(synonymPath, "not_applicable", "_amendment_to_termination_currency", "two_affected_parties");
        if (!notApplicableSubMappings.isEmpty()) {
            notApplicableSubMappings.forEach(m -> this.setValueAndUpdateMappings(m.getXmlPath(), x -> {}));
            return;
        }
        TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder terminationCurrencyAmendmentBuilder = (TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder)builder;
        List<CounterpartyRoleEnum> counterparties = CreateiQMappingProcessorUtils.PARTIES.stream().map(CreateiQMappingProcessorUtils::toCounterpartyRoleEnum).collect(Collectors.toList());
        if (synonymPath.endsWith(new String[]{"amendment_to_termination_currency"})) {
            CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getSpecifiedTerminationCurrencyElection(synonymPath, party + "_termination_currency", Collections.singletonList(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party))).ifPresent(terminationCurrencyAmendmentBuilder::addPartyElection));
            this.getSpecifiedTerminationCurrencyElection(synonymPath, "both_parties_termination_currency", counterparties).ifPresent(terminationCurrencyAmendmentBuilder::addPartyElection);
        }
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> {
            String isSpecifiedSynonym = party + "_amendment_to_termination_currency";
            String currencySynonym = party + "_currency";
            this.getOptionalTerminationCurrencyElection(synonymPath, isSpecifiedSynonym, currencySynonym, Collections.singletonList(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party))).ifPresent(terminationCurrencyAmendmentBuilder::addPartyElection);
        });
        this.getOptionalTerminationCurrencyElection(synonymPath, "two_affected_parties", "two_affected_parties_currency", counterparties).ifPresent(terminationCurrencyAmendmentBuilder::addPartyElection);
    }

    private Optional<TerminationCurrencyElection> getSpecifiedTerminationCurrencyElection(Path basePath, String currencySynonym, List<CounterpartyRoleEnum> parties) {
        TerminationCurrencyElection.TerminationCurrencyElectionBuilder terminationCurrencyElectionBuilder = TerminationCurrencyElection.builder();
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)basePath.addElement(currencySynonym), value -> {
            terminationCurrencyElectionBuilder.addParty(parties).setIsSpecified(true);
            return CdmMappingProcessorUtils.setIsoCurrency((ISOCurrencyCodeEnum)this.getSynonymToEnumMap().getEnumValue(ISOCurrencyCodeEnum.class, value), terminationCurrencyElectionBuilder::setCurrency);
        }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return terminationCurrencyElectionBuilder.hasData() ? Optional.of(terminationCurrencyElectionBuilder.build()) : Optional.empty();
    }

    private Optional<TerminationCurrencyElection> getOptionalTerminationCurrencyElection(Path basePath, String isSpecifiedSynonym, String currencySynonym, List<CounterpartyRoleEnum> parties) {
        TerminationCurrencyElection.TerminationCurrencyElectionBuilder terminationCurrencyElectionBuilder = TerminationCurrencyElection.builder();
        this.setValueAndUpdateMappings(basePath.addElement(isSpecifiedSynonym), value -> terminationCurrencyElectionBuilder.addParty(parties).setIsSpecified("specify".equals(value)));
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)basePath.addElement(currencySynonym), value -> CdmMappingProcessorUtils.setIsoCurrency((ISOCurrencyCodeEnum)this.getSynonymToEnumMap().getEnumValue(ISOCurrencyCodeEnum.class, value), terminationCurrencyElectionBuilder::setCurrency), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return terminationCurrencyElectionBuilder.hasData() ? Optional.of(terminationCurrencyElectionBuilder.build()) : Optional.empty();
    }

    private List<Mapping> anySubPathValueMatches(Path synonymPath, String valueSearchTerm, String ... subPathEndsWith) {
        List<String> foo = Arrays.asList(subPathEndsWith);
        return this.getMappings().stream().filter(m -> synonymPath.fullStartMatches(m.getXmlPath())).filter(m -> foo.stream().anyMatch(m.getXmlPath().toString()::endsWith)).filter(m -> valueSearchTerm.equals(m.getXmlValue())).collect(Collectors.toList());
    }
}

