/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.functions;

import cdm.base.math.functions.Max;
import cdm.legaldocumentation.csa.MarginApproachEnum;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CreditSupportAmountDefault.class)
public abstract class CreditSupportAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Max max;

    public Money evaluate(Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, String baseCurrency) {
        Money result;
        this.conditionValidator.validate(() -> {
            ComparisonResult ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)marginAmountIA)).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)marginAmountIA).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString2 -> fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
            return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)marginAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)threshold).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All)).and(ifThenElseResult);
        }, "");
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.DISTINCT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.ALLOCATED)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)marginAmountIA));
            }
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.GREATER_OF)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)marginAmountIA));
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "");
        Money.MoneyBuilder resultBuilder = this.doEvaluate(marginAmount, threshold, marginApproach, marginAmountIA, baseCurrency);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract Money.MoneyBuilder doEvaluate(Money var1, Money var2, MarginApproachEnum var3, Money var4, String var5);

    protected abstract MapperS<BigDecimal> creditSupportAmountCalc(Money var1, Money var2, MarginApproachEnum var3, Money var4, String var5);

    public static class CreditSupportAmountDefault
    extends CreditSupportAmount {
        @Override
        protected Money.MoneyBuilder doEvaluate(Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, String baseCurrency) {
            Money.MoneyBuilder result = Money.builder();
            return this.assignOutput(result, marginAmount, threshold, marginApproach, marginAmountIA, baseCurrency);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder result, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, String baseCurrency) {
            BigDecimal ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.DISTINCT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.ALLOCATED)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.creditSupportAmountCalc(marginAmount, threshold, marginApproach, marginAmountIA, baseCurrency).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)marginApproach)), (Mapper)MapperS.of((Object)((Object)MarginApproachEnum.GREATER_OF)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.max.evaluate((BigDecimal)this.creditSupportAmountCalc(marginAmount, threshold, marginApproach, marginAmountIA, baseCurrency).get(), (BigDecimal)MapperS.of((Object)marginAmountIA).map("getValue", money -> money.getValue()).get()) : null);
            result.setValue(ifThenElseResult);
            result.getOrCreateUnit().setCurrency(baseCurrency == null ? FieldWithMetaString.builder().build() : FieldWithMetaString.builder().setValue(baseCurrency).build());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> creditSupportAmountCalc(Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, String baseCurrency) {
            return MapperS.of((Object)this.max.evaluate((BigDecimal)MapperMaths.subtract((Mapper)MapperS.of((Object)marginAmount).map("getValue", money -> money.getValue()), (Mapper)MapperS.of((Object)threshold).map("getValue", money -> money.getValue())).get(), new BigDecimal("0.0")));
        }
    }
}

