/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.legaldocumentation.csa.ExposureScopeProductEnum;
import cdm.legaldocumentation.csa.meta.ExcludedProductsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExcludedProducts", builder=ExcludedProductsBuilderImpl.class, version="6.10.0")
@RuneDataType(value="ExcludedProducts", model="cdm", builder=ExcludedProductsBuilderImpl.class, version="6.10.0")
public interface ExcludedProducts
extends RosettaModelObject {
    public static final ExcludedProductsMeta metaData = new ExcludedProductsMeta();

    public List<ExposureScopeProductEnum> getProduct();

    public List<BusinessCenterEnum> getBranch();

    public Boolean getExcluded();

    public ExcludedProducts build();

    public ExcludedProductsBuilder toBuilder();

    public static ExcludedProductsBuilder builder() {
        return new ExcludedProductsBuilderImpl();
    }

    default public RosettaMetaData<? extends ExcludedProducts> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExcludedProducts> getType() {
        return ExcludedProducts.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("product"), ExposureScopeProductEnum.class, this.getProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("branch"), BusinessCenterEnum.class, this.getBranch(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excluded"), Boolean.class, (Object)this.getExcluded(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExcludedProductsBuilderImpl
    implements ExcludedProductsBuilder {
        protected List<ExposureScopeProductEnum> product = new ArrayList<ExposureScopeProductEnum>();
        protected List<BusinessCenterEnum> branch = new ArrayList<BusinessCenterEnum>();
        protected Boolean excluded;

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<ExposureScopeProductEnum> getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="branch")
        @RuneAttribute(value="branch")
        public List<BusinessCenterEnum> getBranch() {
            return this.branch;
        }

        @Override
        @RosettaAttribute(value="excluded", isRequired=true)
        @RuneAttribute(value="excluded", isRequired=true)
        public Boolean getExcluded() {
            return this.excluded;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public ExcludedProductsBuilder addProduct(ExposureScopeProductEnum _product) {
            if (_product != null) {
                this.product.add(_product);
            }
            return this;
        }

        @Override
        public ExcludedProductsBuilder addProduct(ExposureScopeProductEnum _product, int idx) {
            this.getIndex(this.product, idx, () -> _product);
            return this;
        }

        @Override
        public ExcludedProductsBuilder addProduct(List<ExposureScopeProductEnum> products) {
            if (products != null) {
                for (ExposureScopeProductEnum toAdd : products) {
                    this.product.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="product")
        public ExcludedProductsBuilder setProduct(List<ExposureScopeProductEnum> products) {
            this.product = products == null ? new ArrayList<ExposureScopeProductEnum>() : (List)products.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="branch")
        @RuneAttribute(value="branch")
        public ExcludedProductsBuilder addBranch(BusinessCenterEnum _branch) {
            if (_branch != null) {
                this.branch.add(_branch);
            }
            return this;
        }

        @Override
        public ExcludedProductsBuilder addBranch(BusinessCenterEnum _branch, int idx) {
            this.getIndex(this.branch, idx, () -> _branch);
            return this;
        }

        @Override
        public ExcludedProductsBuilder addBranch(List<BusinessCenterEnum> branchs) {
            if (branchs != null) {
                for (BusinessCenterEnum toAdd : branchs) {
                    this.branch.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="branch")
        public ExcludedProductsBuilder setBranch(List<BusinessCenterEnum> branchs) {
            this.branch = branchs == null ? new ArrayList<BusinessCenterEnum>() : (List)branchs.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="excluded", isRequired=true)
        @RuneAttribute(value="excluded", isRequired=true)
        public ExcludedProductsBuilder setExcluded(Boolean _excluded) {
            this.excluded = _excluded == null ? null : _excluded;
            return this;
        }

        @Override
        public ExcludedProducts build() {
            return new ExcludedProductsImpl(this);
        }

        @Override
        public ExcludedProductsBuilder toBuilder() {
            return this;
        }

        @Override
        public ExcludedProductsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getProduct() != null && !this.getProduct().isEmpty()) {
                return true;
            }
            if (this.getBranch() != null && !this.getBranch().isEmpty()) {
                return true;
            }
            return this.getExcluded() != null;
        }

        public ExcludedProductsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExcludedProductsBuilder o = (ExcludedProductsBuilder)other;
            merger.mergeBasic(this.getProduct(), o.getProduct(), this::addProduct);
            merger.mergeBasic(this.getBranch(), o.getBranch(), this::addBranch);
            merger.mergeBasic((Object)this.getExcluded(), (Object)o.getExcluded(), this::setExcluded, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExcludedProducts _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.branch, _that.getBranch())) {
                return false;
            }
            return Objects.equals(this.excluded, _that.getExcluded());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.branch != null ? this.branch.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExcludedProductsBuilder {product=" + this.product + ", branch=" + this.branch + ", excluded=" + this.excluded + '}';
        }
    }

    public static interface ExcludedProductsBuilder
    extends ExcludedProducts,
    RosettaModelObjectBuilder {
        public ExcludedProductsBuilder addProduct(ExposureScopeProductEnum var1);

        public ExcludedProductsBuilder addProduct(ExposureScopeProductEnum var1, int var2);

        public ExcludedProductsBuilder addProduct(List<ExposureScopeProductEnum> var1);

        public ExcludedProductsBuilder setProduct(List<ExposureScopeProductEnum> var1);

        public ExcludedProductsBuilder addBranch(BusinessCenterEnum var1);

        public ExcludedProductsBuilder addBranch(BusinessCenterEnum var1, int var2);

        public ExcludedProductsBuilder addBranch(List<BusinessCenterEnum> var1);

        public ExcludedProductsBuilder setBranch(List<BusinessCenterEnum> var1);

        public ExcludedProductsBuilder setExcluded(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("product"), ExposureScopeProductEnum.class, this.getProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("branch"), BusinessCenterEnum.class, this.getBranch(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excluded"), Boolean.class, (Object)this.getExcluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ExcludedProductsBuilder prune();
    }

    public static class ExcludedProductsImpl
    implements ExcludedProducts {
        private final List<ExposureScopeProductEnum> product;
        private final List<BusinessCenterEnum> branch;
        private final Boolean excluded;

        protected ExcludedProductsImpl(ExcludedProductsBuilder builder) {
            this.product = Optional.ofNullable(builder.getProduct()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.branch = Optional.ofNullable(builder.getBranch()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.excluded = builder.getExcluded();
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<ExposureScopeProductEnum> getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="branch")
        @RuneAttribute(value="branch")
        public List<BusinessCenterEnum> getBranch() {
            return this.branch;
        }

        @Override
        @RosettaAttribute(value="excluded", isRequired=true)
        @RuneAttribute(value="excluded", isRequired=true)
        public Boolean getExcluded() {
            return this.excluded;
        }

        @Override
        public ExcludedProducts build() {
            return this;
        }

        @Override
        public ExcludedProductsBuilder toBuilder() {
            ExcludedProductsBuilder builder = ExcludedProducts.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExcludedProductsBuilder builder) {
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getBranch()).ifPresent(builder::setBranch);
            Optional.ofNullable(this.getExcluded()).ifPresent(builder::setExcluded);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExcludedProducts _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.branch, _that.getBranch())) {
                return false;
            }
            return Objects.equals(this.excluded, _that.getExcluded());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.branch != null ? this.branch.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExcludedProducts {product=" + this.product + ", branch=" + this.branch + ", excluded=" + this.excluded + '}';
        }
    }
}

