/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.event.common.metafields.ReferenceWithMetaTrade;
import cdm.event.position.PositionStatusEnum;
import cdm.event.position.meta.AggregationParametersMeta;
import cdm.product.template.NonTransferableProduct;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AggregationParameters", builder=AggregationParametersBuilderImpl.class, version="6.10.0")
@RuneDataType(value="AggregationParameters", model="cdm", builder=AggregationParametersBuilderImpl.class, version="6.10.0")
public interface AggregationParameters
extends RosettaModelObject {
    public static final AggregationParametersMeta metaData = new AggregationParametersMeta();

    public ZonedDateTime getDateTime();

    public Boolean getTotalPosition();

    public PositionStatusEnum getPositionStatus();

    public List<? extends ReferenceWithMetaParty> getParty();

    public List<? extends NonTransferableProduct> getProduct();

    public List<String> getProductQualifier();

    public List<? extends ReferenceWithMetaTrade> getTradeReference();

    public AggregationParameters build();

    public AggregationParametersBuilder toBuilder();

    public static AggregationParametersBuilder builder() {
        return new AggregationParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends AggregationParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AggregationParameters> getType() {
        return AggregationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, (Object)this.getDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalPosition"), Boolean.class, (Object)this.getTotalPosition(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("positionStatus"), PositionStatusEnum.class, (Object)this.getPositionStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, ReferenceWithMetaParty.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, NonTransferableProduct.class, this.getProduct(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productQualifier"), String.class, this.getProductQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.class, this.getTradeReference(), new AttributeMeta[0]);
    }

    public static class AggregationParametersBuilderImpl
    implements AggregationParametersBuilder {
        protected ZonedDateTime dateTime;
        protected Boolean totalPosition;
        protected PositionStatusEnum positionStatus;
        protected List<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> party = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
        protected List<NonTransferableProduct.NonTransferableProductBuilder> product = new ArrayList<NonTransferableProduct.NonTransferableProductBuilder>();
        protected List<String> productQualifier = new ArrayList<String>();
        protected List<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public ZonedDateTime getDateTime() {
            return this.dateTime;
        }

        @Override
        @RosettaAttribute(value="totalPosition")
        @RuneAttribute(value="totalPosition")
        public Boolean getTotalPosition() {
            return this.totalPosition;
        }

        @Override
        @RosettaAttribute(value="positionStatus")
        @RuneAttribute(value="positionStatus")
        public PositionStatusEnum getPositionStatus() {
            return this.positionStatus;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
            }
            return (ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder)this.getIndex(this.party, index, () -> {
                ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder newParty = ReferenceWithMetaParty.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<? extends NonTransferableProduct.NonTransferableProductBuilder> getProduct() {
            return this.product;
        }

        @Override
        public NonTransferableProduct.NonTransferableProductBuilder getOrCreateProduct(int index) {
            if (this.product == null) {
                this.product = new ArrayList<NonTransferableProduct.NonTransferableProductBuilder>();
            }
            return (NonTransferableProduct.NonTransferableProductBuilder)this.getIndex(this.product, index, () -> {
                NonTransferableProduct.NonTransferableProductBuilder newProduct = NonTransferableProduct.builder();
                return newProduct;
            });
        }

        @Override
        @RosettaAttribute(value="productQualifier")
        @RuneAttribute(value="productQualifier")
        public List<String> getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int index) {
            if (this.tradeReference == null) {
                this.tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();
            }
            return (ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder)this.getIndex(this.tradeReference, index, () -> {
                ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder newTradeReference = ReferenceWithMetaTrade.builder();
                return newTradeReference;
            });
        }

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public AggregationParametersBuilder setDateTime(ZonedDateTime _dateTime) {
            this.dateTime = _dateTime == null ? null : _dateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalPosition")
        @RuneAttribute(value="totalPosition")
        public AggregationParametersBuilder setTotalPosition(Boolean _totalPosition) {
            this.totalPosition = _totalPosition == null ? null : _totalPosition;
            return this;
        }

        @Override
        @RosettaAttribute(value="positionStatus")
        @RuneAttribute(value="positionStatus")
        public AggregationParametersBuilder setPositionStatus(PositionStatusEnum _positionStatus) {
            this.positionStatus = _positionStatus == null ? null : _positionStatus;
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public AggregationParametersBuilder addParty(ReferenceWithMetaParty _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addParty(ReferenceWithMetaParty _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(Party _party) {
            this.getOrCreateParty(-1).setValue(_party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(Party _party, int idx) {
            this.getOrCreateParty(idx).setValue(_party.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addParty(List<? extends ReferenceWithMetaParty> partys) {
            if (partys != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : partys) {
                    this.party.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public AggregationParametersBuilder setParty(List<? extends ReferenceWithMetaParty> partys) {
            this.party = partys == null ? new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder addPartyValue(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.addPartyValue(party);
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setPartyValue(List<? extends Party> partys) {
            this.party.clear();
            if (partys != null) {
                partys.forEach(this::addPartyValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public AggregationParametersBuilder addProduct(NonTransferableProduct _product) {
            if (_product != null) {
                this.product.add(_product.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addProduct(NonTransferableProduct _product, int idx) {
            this.getIndex(this.product, idx, () -> _product.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addProduct(List<? extends NonTransferableProduct> products) {
            if (products != null) {
                for (NonTransferableProduct nonTransferableProduct : products) {
                    this.product.add(nonTransferableProduct.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="product")
        public AggregationParametersBuilder setProduct(List<? extends NonTransferableProduct> products) {
            this.product = products == null ? new ArrayList<NonTransferableProduct.NonTransferableProductBuilder>() : (List)products.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productQualifier")
        @RuneAttribute(value="productQualifier")
        public AggregationParametersBuilder addProductQualifier(String _productQualifier) {
            if (_productQualifier != null) {
                this.productQualifier.add(_productQualifier);
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addProductQualifier(String _productQualifier, int idx) {
            this.getIndex(this.productQualifier, idx, () -> _productQualifier);
            return this;
        }

        @Override
        public AggregationParametersBuilder addProductQualifier(List<String> productQualifiers) {
            if (productQualifiers != null) {
                for (String toAdd : productQualifiers) {
                    this.productQualifier.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productQualifier")
        public AggregationParametersBuilder setProductQualifier(List<String> productQualifiers) {
            this.productQualifier = productQualifiers == null ? new ArrayList<String>() : (List)productQualifiers.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade _tradeReference) {
            if (_tradeReference != null) {
                this.tradeReference.add(_tradeReference.toBuilder());
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade _tradeReference, int idx) {
            this.getIndex(this.tradeReference, idx, () -> _tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(Trade _tradeReference) {
            this.getOrCreateTradeReference(-1).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(Trade _tradeReference, int idx) {
            this.getOrCreateTradeReference(idx).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            if (tradeReferences != null) {
                for (ReferenceWithMetaTrade referenceWithMetaTrade : tradeReferences) {
                    this.tradeReference.add(referenceWithMetaTrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeReference")
        public AggregationParametersBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            this.tradeReference = tradeReferences == null ? new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>() : (List)tradeReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AggregationParametersBuilder addTradeReferenceValue(List<? extends Trade> tradeReferences) {
            if (tradeReferences != null) {
                for (Trade trade : tradeReferences) {
                    this.addTradeReferenceValue(trade);
                }
            }
            return this;
        }

        @Override
        public AggregationParametersBuilder setTradeReferenceValue(List<? extends Trade> tradeReferences) {
            this.tradeReference.clear();
            if (tradeReferences != null) {
                tradeReferences.forEach(this::addTradeReferenceValue);
            }
            return this;
        }

        @Override
        public AggregationParameters build() {
            return new AggregationParametersImpl(this);
        }

        @Override
        public AggregationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public AggregationParametersBuilder prune() {
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.product = this.product.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeReference = this.tradeReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDateTime() != null) {
                return true;
            }
            if (this.getTotalPosition() != null) {
                return true;
            }
            if (this.getPositionStatus() != null) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductQualifier() != null && !this.getProductQualifier().isEmpty()) {
                return true;
            }
            return this.getTradeReference() != null && this.getTradeReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AggregationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AggregationParametersBuilder o = (AggregationParametersBuilder)other;
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getProduct(), o.getProduct(), this::getOrCreateProduct);
            merger.mergeRosetta(this.getTradeReference(), o.getTradeReference(), this::getOrCreateTradeReference);
            merger.mergeBasic((Object)this.getDateTime(), (Object)o.getDateTime(), this::setDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalPosition(), (Object)o.getTotalPosition(), this::setTotalPosition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPositionStatus(), (Object)o.getPositionStatus(), this::setPositionStatus, new AttributeMeta[0]);
            merger.mergeBasic(this.getProductQualifier(), o.getProductQualifier(), this::addProductQualifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AggregationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.dateTime, _that.getDateTime())) {
                return false;
            }
            if (!Objects.equals(this.totalPosition, _that.getTotalPosition())) {
                return false;
            }
            if (!Objects.equals((Object)this.positionStatus, (Object)_that.getPositionStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            _result = 31 * _result + (this.totalPosition != null ? this.totalPosition.hashCode() : 0);
            _result = 31 * _result + (this.positionStatus != null ? ((Object)((Object)this.positionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AggregationParametersBuilder {dateTime=" + this.dateTime + ", totalPosition=" + this.totalPosition + ", positionStatus=" + (Object)((Object)this.positionStatus) + ", party=" + this.party + ", product=" + this.product + ", productQualifier=" + this.productQualifier + ", tradeReference=" + this.tradeReference + '}';
        }
    }

    public static interface AggregationParametersBuilder
    extends AggregationParameters,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateParty(int var1);

        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getParty();

        public NonTransferableProduct.NonTransferableProductBuilder getOrCreateProduct(int var1);

        public List<? extends NonTransferableProduct.NonTransferableProductBuilder> getProduct();

        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int var1);

        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference();

        public AggregationParametersBuilder setDateTime(ZonedDateTime var1);

        public AggregationParametersBuilder setTotalPosition(Boolean var1);

        public AggregationParametersBuilder setPositionStatus(PositionStatusEnum var1);

        public AggregationParametersBuilder addParty(ReferenceWithMetaParty var1);

        public AggregationParametersBuilder addParty(ReferenceWithMetaParty var1, int var2);

        public AggregationParametersBuilder addPartyValue(Party var1);

        public AggregationParametersBuilder addPartyValue(Party var1, int var2);

        public AggregationParametersBuilder addParty(List<? extends ReferenceWithMetaParty> var1);

        public AggregationParametersBuilder setParty(List<? extends ReferenceWithMetaParty> var1);

        public AggregationParametersBuilder addPartyValue(List<? extends Party> var1);

        public AggregationParametersBuilder setPartyValue(List<? extends Party> var1);

        public AggregationParametersBuilder addProduct(NonTransferableProduct var1);

        public AggregationParametersBuilder addProduct(NonTransferableProduct var1, int var2);

        public AggregationParametersBuilder addProduct(List<? extends NonTransferableProduct> var1);

        public AggregationParametersBuilder setProduct(List<? extends NonTransferableProduct> var1);

        public AggregationParametersBuilder addProductQualifier(String var1);

        public AggregationParametersBuilder addProductQualifier(String var1, int var2);

        public AggregationParametersBuilder addProductQualifier(List<String> var1);

        public AggregationParametersBuilder setProductQualifier(List<String> var1);

        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade var1);

        public AggregationParametersBuilder addTradeReference(ReferenceWithMetaTrade var1, int var2);

        public AggregationParametersBuilder addTradeReferenceValue(Trade var1);

        public AggregationParametersBuilder addTradeReferenceValue(Trade var1, int var2);

        public AggregationParametersBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public AggregationParametersBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public AggregationParametersBuilder addTradeReferenceValue(List<? extends Trade> var1);

        public AggregationParametersBuilder setTradeReferenceValue(List<? extends Trade> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, (Object)this.getDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalPosition"), Boolean.class, (Object)this.getTotalPosition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("positionStatus"), PositionStatusEnum.class, (Object)this.getPositionStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, NonTransferableProduct.NonTransferableProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productQualifier"), String.class, this.getProductQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
        }

        public AggregationParametersBuilder prune();
    }

    public static class AggregationParametersImpl
    implements AggregationParameters {
        private final ZonedDateTime dateTime;
        private final Boolean totalPosition;
        private final PositionStatusEnum positionStatus;
        private final List<? extends ReferenceWithMetaParty> party;
        private final List<? extends NonTransferableProduct> product;
        private final List<String> productQualifier;
        private final List<? extends ReferenceWithMetaTrade> tradeReference;

        protected AggregationParametersImpl(AggregationParametersBuilder builder) {
            this.dateTime = builder.getDateTime();
            this.totalPosition = builder.getTotalPosition();
            this.positionStatus = builder.getPositionStatus();
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productQualifier = Optional.ofNullable(builder.getProductQualifier()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public ZonedDateTime getDateTime() {
            return this.dateTime;
        }

        @Override
        @RosettaAttribute(value="totalPosition")
        @RuneAttribute(value="totalPosition")
        public Boolean getTotalPosition() {
            return this.totalPosition;
        }

        @Override
        @RosettaAttribute(value="positionStatus")
        @RuneAttribute(value="positionStatus")
        public PositionStatusEnum getPositionStatus() {
            return this.positionStatus;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends ReferenceWithMetaParty> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<? extends NonTransferableProduct> getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="productQualifier")
        @RuneAttribute(value="productQualifier")
        public List<String> getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTrade> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public AggregationParameters build() {
            return this;
        }

        @Override
        public AggregationParametersBuilder toBuilder() {
            AggregationParametersBuilder builder = AggregationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AggregationParametersBuilder builder) {
            Optional.ofNullable(this.getDateTime()).ifPresent(builder::setDateTime);
            Optional.ofNullable(this.getTotalPosition()).ifPresent(builder::setTotalPosition);
            Optional.ofNullable(this.getPositionStatus()).ifPresent(builder::setPositionStatus);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getProductQualifier()).ifPresent(builder::setProductQualifier);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AggregationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.dateTime, _that.getDateTime())) {
                return false;
            }
            if (!Objects.equals(this.totalPosition, _that.getTotalPosition())) {
                return false;
            }
            if (!Objects.equals((Object)this.positionStatus, (Object)_that.getPositionStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            _result = 31 * _result + (this.totalPosition != null ? this.totalPosition.hashCode() : 0);
            _result = 31 * _result + (this.positionStatus != null ? ((Object)((Object)this.positionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AggregationParameters {dateTime=" + this.dateTime + ", totalPosition=" + this.totalPosition + ", positionStatus=" + (Object)((Object)this.positionStatus) + ", party=" + this.party + ", product=" + this.product + ", productQualifier=" + this.productQualifier + ", tradeReference=" + this.tradeReference + '}';
        }
    }
}

