/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.PartyChangeInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyChangeInstruction", builder=PartyChangeInstructionBuilderImpl.class, version="6.10.0")
@RuneDataType(value="PartyChangeInstruction", model="cdm", builder=PartyChangeInstructionBuilderImpl.class, version="6.10.0")
public interface PartyChangeInstruction
extends RosettaModelObject {
    public static final PartyChangeInstructionMeta metaData = new PartyChangeInstructionMeta();

    public Counterparty getCounterparty();

    public AncillaryParty getAncillaryParty();

    public PartyRole getPartyRole();

    public List<? extends TradeIdentifier> getTradeId();

    public PartyChangeInstruction build();

    public PartyChangeInstructionBuilder toBuilder();

    public static PartyChangeInstructionBuilder builder() {
        return new PartyChangeInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyChangeInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyChangeInstruction> getType() {
        return PartyChangeInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.class, this.getAncillaryParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeId"), processor, TradeIdentifier.class, this.getTradeId(), new AttributeMeta[0]);
    }

    public static class PartyChangeInstructionBuilderImpl
    implements PartyChangeInstructionBuilder {
        protected Counterparty.CounterpartyBuilder counterparty;
        protected AncillaryParty.AncillaryPartyBuilder ancillaryParty;
        protected PartyRole.PartyRoleBuilder partyRole;
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public Counterparty.CounterpartyBuilder getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty() {
            Counterparty.CounterpartyBuilder result = this.counterparty != null ? this.counterparty : (this.counterparty = Counterparty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public AncillaryParty.AncillaryPartyBuilder getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty() {
            AncillaryParty.AncillaryPartyBuilder result = this.ancillaryParty != null ? this.ancillaryParty : (this.ancillaryParty = AncillaryParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public PartyRole.PartyRoleBuilder getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole() {
            PartyRole.PartyRoleBuilder result = this.partyRole != null ? this.partyRole : (this.partyRole = PartyRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeId() {
            return this.tradeId;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeId(int index) {
            if (this.tradeId == null) {
                this.tradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeId, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeId = TradeIdentifier.builder();
                return newTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public PartyChangeInstructionBuilder setCounterparty(Counterparty _counterparty) {
            this.counterparty = _counterparty == null ? null : _counterparty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public PartyChangeInstructionBuilder setAncillaryParty(AncillaryParty _ancillaryParty) {
            this.ancillaryParty = _ancillaryParty == null ? null : _ancillaryParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public PartyChangeInstructionBuilder setPartyRole(PartyRole _partyRole) {
            this.partyRole = _partyRole == null ? null : _partyRole.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public PartyChangeInstructionBuilder addTradeId(TradeIdentifier _tradeId) {
            if (_tradeId != null) {
                this.tradeId.add(_tradeId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyChangeInstructionBuilder addTradeId(TradeIdentifier _tradeId, int idx) {
            this.getIndex(this.tradeId, idx, () -> _tradeId.toBuilder());
            return this;
        }

        @Override
        public PartyChangeInstructionBuilder addTradeId(List<? extends TradeIdentifier> tradeIds) {
            if (tradeIds != null) {
                for (TradeIdentifier tradeIdentifier : tradeIds) {
                    this.tradeId.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeId")
        public PartyChangeInstructionBuilder setTradeId(List<? extends TradeIdentifier> tradeIds) {
            this.tradeId = tradeIds == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyChangeInstruction build() {
            return new PartyChangeInstructionImpl(this);
        }

        @Override
        public PartyChangeInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyChangeInstructionBuilder prune() {
            if (this.counterparty != null && !this.counterparty.prune().hasData()) {
                this.counterparty = null;
            }
            if (this.ancillaryParty != null && !this.ancillaryParty.prune().hasData()) {
                this.ancillaryParty = null;
            }
            if (this.partyRole != null && !this.partyRole.prune().hasData()) {
                this.partyRole = null;
            }
            this.tradeId = this.tradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCounterparty() != null && this.getCounterparty().hasData()) {
                return true;
            }
            if (this.getAncillaryParty() != null && this.getAncillaryParty().hasData()) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().hasData()) {
                return true;
            }
            return this.getTradeId() != null && this.getTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyChangeInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyChangeInstructionBuilder o = (PartyChangeInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterparty(), (RosettaModelObjectBuilder)o.getCounterparty(), this::setCounterparty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAncillaryParty(), (RosettaModelObjectBuilder)o.getAncillaryParty(), this::setAncillaryParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyRole(), (RosettaModelObjectBuilder)o.getPartyRole(), this::setPartyRole);
            merger.mergeRosetta(this.getTradeId(), o.getTradeId(), this::getOrCreateTradeId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyChangeInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!Objects.equals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyChangeInstructionBuilder {counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", partyRole=" + this.partyRole + ", tradeId=" + this.tradeId + '}';
        }
    }

    public static interface PartyChangeInstructionBuilder
    extends PartyChangeInstruction,
    RosettaModelObjectBuilder {
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty();

        @Override
        public Counterparty.CounterpartyBuilder getCounterparty();

        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty();

        @Override
        public AncillaryParty.AncillaryPartyBuilder getAncillaryParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole();

        @Override
        public PartyRole.PartyRoleBuilder getPartyRole();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeId(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeId();

        public PartyChangeInstructionBuilder setCounterparty(Counterparty var1);

        public PartyChangeInstructionBuilder setAncillaryParty(AncillaryParty var1);

        public PartyChangeInstructionBuilder setPartyRole(PartyRole var1);

        public PartyChangeInstructionBuilder addTradeId(TradeIdentifier var1);

        public PartyChangeInstructionBuilder addTradeId(TradeIdentifier var1, int var2);

        public PartyChangeInstructionBuilder addTradeId(List<? extends TradeIdentifier> var1);

        public PartyChangeInstructionBuilder setTradeId(List<? extends TradeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.AncillaryPartyBuilder.class, this.getAncillaryParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeId"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeId(), new AttributeMeta[0]);
        }

        public PartyChangeInstructionBuilder prune();
    }

    public static class PartyChangeInstructionImpl
    implements PartyChangeInstruction {
        private final Counterparty counterparty;
        private final AncillaryParty ancillaryParty;
        private final PartyRole partyRole;
        private final List<? extends TradeIdentifier> tradeId;

        protected PartyChangeInstructionImpl(PartyChangeInstructionBuilder builder) {
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).map(f -> f.build()).orElse(null);
            this.ancillaryParty = Optional.ofNullable(builder.getAncillaryParty()).map(f -> f.build()).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).map(f -> f.build()).orElse(null);
            this.tradeId = Optional.ofNullable(builder.getTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public Counterparty getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public AncillaryParty getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public PartyRole getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public List<? extends TradeIdentifier> getTradeId() {
            return this.tradeId;
        }

        @Override
        public PartyChangeInstruction build() {
            return this;
        }

        @Override
        public PartyChangeInstructionBuilder toBuilder() {
            PartyChangeInstructionBuilder builder = PartyChangeInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyChangeInstructionBuilder builder) {
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getAncillaryParty()).ifPresent(builder::setAncillaryParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getTradeId()).ifPresent(builder::setTradeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyChangeInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!Objects.equals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyChangeInstruction {counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", partyRole=" + this.partyRole + ", tradeId=" + this.tradeId + '}';
        }
    }
}

