/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.processor;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;

public class TaxonomySourceMappingProcessor
extends MappingProcessor {
    public TaxonomySourceMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public <T> void mapBasic(Path synonymPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        Path productTaxonomyModelPath = PathUtils.toPath((RosettaPath)this.getModelPath()).getParent();
        Path taxomomyValueModelPath = productTaxonomyModelPath.addElement("value");
        Path nameModelPath = taxomomyValueModelPath.addElement("name").addElement("value");
        MappingProcessorUtils.getNonNullMappingForModelPath((List)this.getMappings(), (Path)nameModelPath).map(Mapping::getXmlPath).ifPresent(xmlPath -> {
            ProductTaxonomy.ProductTaxonomyBuilder productTaxonomyBuilder = (ProductTaxonomy.ProductTaxonomyBuilder)parent;
            this.updateSchemeAndSource((Path)xmlPath, productTaxonomyBuilder);
            if (productTaxonomyBuilder.getValue() != null && productTaxonomyBuilder.getSource() == null) {
                productTaxonomyBuilder.setSource(TaxonomySourceEnum.OTHER);
            }
        });
    }

    protected void updateSchemeAndSource(Path xmlPath, ProductTaxonomy.ProductTaxonomyBuilder productTaxonomyBuilder) {
        this.setValueAndUpdateMappings(xmlPath.addElement("productTypeScheme"), xmlValue -> {
            if ("http://www.fpml.org/coding-scheme/esma-emir-refit-crypto-asset-indicator".equals(xmlValue)) {
                productTaxonomyBuilder.setValue(null);
            } else {
                productTaxonomyBuilder.getOrCreateValue().getOrCreateName().getOrCreateMeta().setScheme(xmlValue);
                productTaxonomyBuilder.setSource(this.getTaxonomySourceEnum((String)xmlValue));
            }
        });
    }

    protected TaxonomySourceEnum getTaxonomySourceEnum(String scheme) {
        if (scheme.contains("www.fpml.org/coding-scheme/product-taxonomy")) {
            return TaxonomySourceEnum.ISDA;
        }
        if (scheme.contains("iso10962")) {
            return TaxonomySourceEnum.CFI;
        }
        if (scheme.contains("emir-contract-type")) {
            return TaxonomySourceEnum.EMIR;
        }
        return TaxonomySourceEnum.OTHER;
    }
}

