/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="InstrumentTypeEnum")
public enum InstrumentTypeEnum {
    DEBT("Debt", null),
    EQUITY("Equity", null),
    FUND("Fund", null),
    WARRANT("Warrant", null),
    CERTIFICATE("Certificate", null),
    LETTER_OF_CREDIT("LetterOfCredit", null),
    LISTED_DERIVATIVE("ListedDerivative", null);

    private static Map<String, InstrumentTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private InstrumentTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static InstrumentTypeEnum fromDisplayName(String name) {
        InstrumentTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, InstrumentTypeEnum> map = new ConcurrentHashMap<String, InstrumentTypeEnum>();
        for (InstrumentTypeEnum instance : InstrumentTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

