/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.DigitalAsset;
import cdm.base.staticdata.asset.common.Instrument;
import cdm.base.staticdata.asset.common.meta.AssetMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Asset", builder=AssetBuilderImpl.class, version="6.10.0")
@RuneDataType(value="Asset", model="cdm", builder=AssetBuilderImpl.class, version="6.10.0")
public interface Asset
extends RosettaModelObject {
    public static final AssetMeta metaData = new AssetMeta();

    public Cash getCash();

    public Commodity getCommodity();

    public DigitalAsset getDigitalAsset();

    public Instrument getInstrument();

    public Asset build();

    public AssetBuilder toBuilder();

    public static AssetBuilder builder() {
        return new AssetBuilderImpl();
    }

    default public RosettaMetaData<? extends Asset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Asset> getType() {
        return Asset.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("Cash"), processor, Cash.class, this.getCash(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("DigitalAsset"), processor, DigitalAsset.class, this.getDigitalAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Instrument"), processor, Instrument.class, this.getInstrument(), new AttributeMeta[0]);
    }

    public static class AssetBuilderImpl
    implements AssetBuilder {
        protected Cash.CashBuilder cash;
        protected Commodity.CommodityBuilder commodity;
        protected DigitalAsset.DigitalAssetBuilder digitalAsset;
        protected Instrument.InstrumentBuilder instrument;

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public Cash.CashBuilder getCash() {
            return this.cash;
        }

        @Override
        public Cash.CashBuilder getOrCreateCash() {
            Cash.CashBuilder result = this.cash != null ? this.cash : (this.cash = Cash.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public Commodity.CommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public Commodity.CommodityBuilder getOrCreateCommodity() {
            Commodity.CommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = Commodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="DigitalAsset")
        @RuneAttribute(value="DigitalAsset")
        public DigitalAsset.DigitalAssetBuilder getDigitalAsset() {
            return this.digitalAsset;
        }

        @Override
        public DigitalAsset.DigitalAssetBuilder getOrCreateDigitalAsset() {
            DigitalAsset.DigitalAssetBuilder result = this.digitalAsset != null ? this.digitalAsset : (this.digitalAsset = DigitalAsset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Instrument")
        @RuneAttribute(value="Instrument")
        public Instrument.InstrumentBuilder getInstrument() {
            return this.instrument;
        }

        @Override
        public Instrument.InstrumentBuilder getOrCreateInstrument() {
            Instrument.InstrumentBuilder result = this.instrument != null ? this.instrument : (this.instrument = Instrument.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public AssetBuilder setCash(Cash _cash) {
            this.cash = _cash == null ? null : _cash.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public AssetBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="DigitalAsset")
        @RuneAttribute(value="DigitalAsset")
        public AssetBuilder setDigitalAsset(DigitalAsset _digitalAsset) {
            this.digitalAsset = _digitalAsset == null ? null : _digitalAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Instrument")
        @RuneAttribute(value="Instrument")
        public AssetBuilder setInstrument(Instrument _instrument) {
            this.instrument = _instrument == null ? null : _instrument.toBuilder();
            return this;
        }

        @Override
        public Asset build() {
            return new AssetImpl(this);
        }

        @Override
        public AssetBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetBuilder prune() {
            if (this.cash != null && !this.cash.prune().hasData()) {
                this.cash = null;
            }
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            if (this.digitalAsset != null && !this.digitalAsset.prune().hasData()) {
                this.digitalAsset = null;
            }
            if (this.instrument != null && !this.instrument.prune().hasData()) {
                this.instrument = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCash() != null && this.getCash().hasData()) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getDigitalAsset() != null && this.getDigitalAsset().hasData()) {
                return true;
            }
            return this.getInstrument() != null && this.getInstrument().hasData();
        }

        public AssetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetBuilder o = (AssetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCash(), (RosettaModelObjectBuilder)o.getCash(), this::setCash);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDigitalAsset(), (RosettaModelObjectBuilder)o.getDigitalAsset(), this::setDigitalAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInstrument(), (RosettaModelObjectBuilder)o.getInstrument(), this::setInstrument);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Asset _that = this.getType().cast(o);
            if (!Objects.equals(this.cash, _that.getCash())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.digitalAsset, _that.getDigitalAsset())) {
                return false;
            }
            return Objects.equals(this.instrument, _that.getInstrument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cash != null ? this.cash.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.digitalAsset != null ? this.digitalAsset.hashCode() : 0);
            _result = 31 * _result + (this.instrument != null ? this.instrument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetBuilder {Cash=" + this.cash + ", Commodity=" + this.commodity + ", DigitalAsset=" + this.digitalAsset + ", Instrument=" + this.instrument + '}';
        }
    }

    public static interface AssetBuilder
    extends Asset,
    RosettaModelObjectBuilder {
        public Cash.CashBuilder getOrCreateCash();

        @Override
        public Cash.CashBuilder getCash();

        public Commodity.CommodityBuilder getOrCreateCommodity();

        @Override
        public Commodity.CommodityBuilder getCommodity();

        public DigitalAsset.DigitalAssetBuilder getOrCreateDigitalAsset();

        @Override
        public DigitalAsset.DigitalAssetBuilder getDigitalAsset();

        public Instrument.InstrumentBuilder getOrCreateInstrument();

        @Override
        public Instrument.InstrumentBuilder getInstrument();

        public AssetBuilder setCash(Cash var1);

        public AssetBuilder setCommodity(Commodity var1);

        public AssetBuilder setDigitalAsset(DigitalAsset var1);

        public AssetBuilder setInstrument(Instrument var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("Cash"), processor, Cash.CashBuilder.class, this.getCash(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.CommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("DigitalAsset"), processor, DigitalAsset.DigitalAssetBuilder.class, this.getDigitalAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Instrument"), processor, Instrument.InstrumentBuilder.class, this.getInstrument(), new AttributeMeta[0]);
        }

        public AssetBuilder prune();
    }

    public static class AssetImpl
    implements Asset {
        private final Cash cash;
        private final Commodity commodity;
        private final DigitalAsset digitalAsset;
        private final Instrument instrument;

        protected AssetImpl(AssetBuilder builder) {
            this.cash = Optional.ofNullable(builder.getCash()).map(f -> f.build()).orElse(null);
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.digitalAsset = Optional.ofNullable(builder.getDigitalAsset()).map(f -> f.build()).orElse(null);
            this.instrument = Optional.ofNullable(builder.getInstrument()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public Cash getCash() {
            return this.cash;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public Commodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="DigitalAsset")
        @RuneAttribute(value="DigitalAsset")
        public DigitalAsset getDigitalAsset() {
            return this.digitalAsset;
        }

        @Override
        @RosettaAttribute(value="Instrument")
        @RuneAttribute(value="Instrument")
        public Instrument getInstrument() {
            return this.instrument;
        }

        @Override
        public Asset build() {
            return this;
        }

        @Override
        public AssetBuilder toBuilder() {
            AssetBuilder builder = Asset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetBuilder builder) {
            Optional.ofNullable(this.getCash()).ifPresent(builder::setCash);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getDigitalAsset()).ifPresent(builder::setDigitalAsset);
            Optional.ofNullable(this.getInstrument()).ifPresent(builder::setInstrument);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Asset _that = this.getType().cast(o);
            if (!Objects.equals(this.cash, _that.getCash())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.digitalAsset, _that.getDigitalAsset())) {
                return false;
            }
            return Objects.equals(this.instrument, _that.getInstrument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cash != null ? this.cash.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.digitalAsset != null ? this.digitalAsset.hashCode() : 0);
            _result = 31 * _result + (this.instrument != null ? this.instrument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Asset {Cash=" + this.cash + ", Commodity=" + this.commodity + ", DigitalAsset=" + this.digitalAsset + ", Instrument=" + this.instrument + '}';
        }
    }
}

