# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MandatoryEarlyTermination']


class MandatoryEarlyTermination(BaseDataClass):
    """
    A data to:  define an early termination provision for which exercise is mandatory.
    """
    mandatoryEarlyTerminationDate: cdm.base.datetime.AdjustableDate.AdjustableDate = Field(..., description="The early termination date associated with a mandatory early termination of a swap.")
    """
    The early termination date associated with a mandatory early termination of a swap.
    """
    calculationAgent: cdm.observable.asset.CalculationAgent.CalculationAgent = Field(..., description="The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.")
    """
    The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
    """
    cashSettlement: cdm.product.common.settlement.SettlementTerms.SettlementTerms = Field(..., description="If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.")
    """
    If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
    """
    mandatoryEarlyTerminationAdjustedDates: Optional[cdm.product.template.MandatoryEarlyTerminationAdjustedDates.MandatoryEarlyTerminationAdjustedDates] = Field(None, description="The adjusted dates associated with a mandatory early termination provision. These dates have been adjusted for any applicable business day convention.")
    """
    The adjusted dates associated with a mandatory early termination provision. These dates have been adjusted for any applicable business day convention.
    """
    
    @rosetta_condition
    def condition_0_MandatoryEarlyTerminationCalculationAgent(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_MANDATORY_EARLY_TERMINATION"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.datetime.AdjustableDate
import cdm.observable.asset.CalculationAgent
import cdm.product.common.settlement.SettlementTerms
import cdm.product.template.MandatoryEarlyTerminationAdjustedDates
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
