# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExerciseNotice']


class ExerciseNotice(BaseDataClass):
    """
    Defines to whom and where notice of execution should be given. The exerciseNoticeGiver refers to one or both of the principal parties of the trade. If present the exerciseNoticeReceiver refers to a party, other than the principal party, to whom notice should be given.
    """
    exerciseNoticeGiver: cdm.product.template.ExerciseNoticeGiverEnum.ExerciseNoticeGiverEnum = Field(..., description="Specifies the principal party of the trade that has the right to exercise.")
    """
    Specifies the principal party of the trade that has the right to exercise.
    """
    exerciseNoticeReceiver: Optional[cdm.base.staticdata.party.AncillaryRoleEnum.AncillaryRoleEnum] = Field(None, description="Specifies the party to which notice of exercise should be given, e.g. by the buyer of the option. Although in many cases it is the buyer of the option who sends the exercise notice to the seller of the option, this component is reused, e.g. in case of OptionEarlyTermination, either or both parties have the right to exercise.")
    """
    Specifies the party to which notice of exercise should be given, e.g. by the buyer of the option. Although in many cases it is the buyer of the option who sends the exercise notice to the seller of the option, this component is reused, e.g. in case of OptionEarlyTermination, either or both parties have the right to exercise.
    """
    businessCenter: AttributeWithMeta[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] | cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum = Field(..., description="Specifies the location where the exercise must be reported, e.g. where the exercise notice receiver is based.")
    """
    Specifies the location where the exercise must be reported, e.g. where the exercise notice receiver is based.
    """

import cdm 
import cdm.product.template.ExerciseNoticeGiverEnum
import cdm.base.staticdata.party.AncillaryRoleEnum
import cdm.base.datetime.BusinessCenterEnum
