# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.common.settlement.functions.PriceUnitEquals import PriceUnitEquals
from cdm.base.math.functions.UpdateAmount import UpdateAmount
from cdm.observable.asset.PriceSchedule import PriceSchedule
from cdm.base.math.QuantityChangeDirectionEnum import QuantityChangeDirectionEnum

__all__ = ['UpdatePriceAmountForEachMatchingQuantity']


@replaceable
def UpdatePriceAmountForEachMatchingQuantity(price: PriceSchedule | None, change: list[PriceSchedule] | None, direction: QuantityChangeDirectionEnum) -> PriceSchedule:
    """
    Updates any price from the PriceSchedule list if the unit of amount matches.
    
    Parameters 
    ----------
    price : PriceSchedule
    List of PriceSchedule to update.
    
    change : PriceSchedule
    List of new PriceSchedule to use where the units match.
    
    direction : QuantityChangeDirectionEnum
    Enum specifying how the updated amounts should be applied, e.g., add, subtract or replace.
    
    Returns
    -------
    updatedPrice : PriceSchedule
    
    """
    self = inspect.currentframe()
    
    
    changedAmount = (lambda item: list(map(lambda item: UpdateAmount(rosetta_resolve_attr(rosetta_resolve_attr(self, "price"), "value"), rosetta_resolve_attr(item, "value"), rosetta_resolve_attr(self, "direction")), item)))((lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(self, "change"), lambda item: PriceUnitEquals(item, rosetta_resolve_attr(self, "price")))))
    updatedPrice =  rosetta_resolve_attr(self, "price")
    updatedPrice = _get_rosetta_object('PriceSchedule', 'value', (rosetta_resolve_attr(self, "changedAmount") default rosetta_resolve_attr(rosetta_resolve_attr(self, "price"), "value")))
    
    
    return updatedPrice

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
