# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['IndependentAmount']

from cdm.base.staticdata.party.PartyReferencePayerReceiver import PartyReferencePayerReceiver

class IndependentAmount(PartyReferencePayerReceiver):
    """
    A class specifying the Independent Amount as the combination of a payer/receiver, a payment amount, a payment date and an associated payment calculation rule.
    """
    paymentDetail: List[cdm.product.common.settlement.PaymentDetail.PaymentDetail] = Field([], description="An attribute that specifies a payment as the combination of a payment amount, a payment date and an associated payment calculation rule.")
    """
    An attribute that specifies a payment as the combination of a payment amount, a payment date and an associated payment calculation rule.
    """
    @rosetta_condition
    def cardinality_paymentDetail(self):
        return check_cardinality(self.paymentDetail, 1, None)
    

import cdm 
import cdm.product.common.settlement.PaymentDetail
