/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ImplementedBy(value=GetQuantityScheduleStepValuesDefault.class)
public abstract class GetQuantityScheduleStepValues
implements RosettaFunction {
    public List<BigDecimal> evaluate(NonNegativeQuantitySchedule schedule, Date periodStartDate) {
        List<BigDecimal> stepValues = this.doEvaluate(schedule, periodStartDate);
        return stepValues;
    }

    protected abstract List<BigDecimal> doEvaluate(NonNegativeQuantitySchedule var1, Date var2);

    public static class GetQuantityScheduleStepValuesDefault
    extends GetQuantityScheduleStepValues {
        @Override
        protected List<BigDecimal> doEvaluate(NonNegativeQuantitySchedule schedule, Date periodStartDate) {
            ArrayList<BigDecimal> stepValues = new ArrayList<BigDecimal>();
            return this.assignOutput(stepValues, schedule, periodStartDate);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> stepValues, NonNegativeQuantitySchedule schedule, Date periodStartDate) {
            stepValues.addAll(MapperS.of((Object)schedule).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).getMulti());
            MapperC thenArg = MapperS.of((Object)schedule).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).filterItemNullSafe(item -> ExpressionOperators.lessThanEquals((Mapper)item.map("getDate", datedValue -> datedValue.getDate()), (Mapper)MapperS.of((Object)periodStartDate), (CardinalityOperator)CardinalityOperator.All).get());
            stepValues.addAll(thenArg.mapItem(item -> item.map("getValue", datedValue -> datedValue.getValue())).getMulti());
            return stepValues;
        }
    }
}

