/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.legaldocumentation.master.MasterAgreementVariableSet;
import cdm.legaldocumentation.master.MasterAgreementVariantIdentifierEnum;
import cdm.legaldocumentation.master.meta.MasterAgreementClauseVariantMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MasterAgreementClauseVariant", builder=MasterAgreementClauseVariantBuilderImpl.class, version="5.28.0")
@RuneDataType(value="MasterAgreementClauseVariant", model="cdm", builder=MasterAgreementClauseVariantBuilderImpl.class, version="5.28.0")
public interface MasterAgreementClauseVariant
extends RosettaModelObject {
    public static final MasterAgreementClauseVariantMeta metaData = new MasterAgreementClauseVariantMeta();

    public MasterAgreementVariantIdentifierEnum getIdentifier();

    public String getName();

    public List<CounterpartyRoleEnum> getCounterparty();

    public List<PartyRoleEnum> getOtherParty();

    public List<? extends MasterAgreementVariableSet> getVariableSet();

    public MasterAgreementClauseVariant build();

    public MasterAgreementClauseVariantBuilder toBuilder();

    public static MasterAgreementClauseVariantBuilder builder() {
        return new MasterAgreementClauseVariantBuilderImpl();
    }

    default public RosettaMetaData<? extends MasterAgreementClauseVariant> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MasterAgreementClauseVariant> getType() {
        return MasterAgreementClauseVariant.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("identifier"), MasterAgreementVariantIdentifierEnum.class, (Object)this.getIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty"), CounterpartyRoleEnum.class, this.getCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherParty"), PartyRoleEnum.class, this.getOtherParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("variableSet"), processor, MasterAgreementVariableSet.class, this.getVariableSet(), new AttributeMeta[0]);
    }

    public static class MasterAgreementClauseVariantBuilderImpl
    implements MasterAgreementClauseVariantBuilder {
        protected MasterAgreementVariantIdentifierEnum identifier;
        protected String name;
        protected List<CounterpartyRoleEnum> counterparty = new ArrayList<CounterpartyRoleEnum>();
        protected List<PartyRoleEnum> otherParty = new ArrayList<PartyRoleEnum>();
        protected List<MasterAgreementVariableSet.MasterAgreementVariableSetBuilder> variableSet = new ArrayList<MasterAgreementVariableSet.MasterAgreementVariableSetBuilder>();

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public MasterAgreementVariantIdentifierEnum getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        @RuneAttribute(value="counterparty")
        public List<CounterpartyRoleEnum> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public List<PartyRoleEnum> getOtherParty() {
            return this.otherParty;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public List<? extends MasterAgreementVariableSet.MasterAgreementVariableSetBuilder> getVariableSet() {
            return this.variableSet;
        }

        @Override
        public MasterAgreementVariableSet.MasterAgreementVariableSetBuilder getOrCreateVariableSet(int index) {
            if (this.variableSet == null) {
                this.variableSet = new ArrayList<MasterAgreementVariableSet.MasterAgreementVariableSetBuilder>();
            }
            return (MasterAgreementVariableSet.MasterAgreementVariableSetBuilder)this.getIndex(this.variableSet, index, () -> {
                MasterAgreementVariableSet.MasterAgreementVariableSetBuilder newVariableSet = MasterAgreementVariableSet.builder();
                return newVariableSet;
            });
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public MasterAgreementClauseVariantBuilder setIdentifier(MasterAgreementVariantIdentifierEnum _identifier) {
            this.identifier = _identifier == null ? null : _identifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public MasterAgreementClauseVariantBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        @RuneAttribute(value="counterparty")
        public MasterAgreementClauseVariantBuilder addCounterparty(CounterpartyRoleEnum _counterparty) {
            if (_counterparty != null) {
                this.counterparty.add(_counterparty);
            }
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addCounterparty(CounterpartyRoleEnum _counterparty, int idx) {
            this.getIndex(this.counterparty, idx, () -> _counterparty);
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addCounterparty(List<CounterpartyRoleEnum> counterpartys) {
            if (counterpartys != null) {
                for (CounterpartyRoleEnum toAdd : counterpartys) {
                    this.counterparty.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterparty")
        public MasterAgreementClauseVariantBuilder setCounterparty(List<CounterpartyRoleEnum> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)counterpartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public MasterAgreementClauseVariantBuilder addOtherParty(PartyRoleEnum _otherParty) {
            if (_otherParty != null) {
                this.otherParty.add(_otherParty);
            }
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addOtherParty(PartyRoleEnum _otherParty, int idx) {
            this.getIndex(this.otherParty, idx, () -> _otherParty);
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addOtherParty(List<PartyRoleEnum> otherPartys) {
            if (otherPartys != null) {
                for (PartyRoleEnum toAdd : otherPartys) {
                    this.otherParty.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherParty")
        public MasterAgreementClauseVariantBuilder setOtherParty(List<PartyRoleEnum> otherPartys) {
            this.otherParty = otherPartys == null ? new ArrayList<PartyRoleEnum>() : (List)otherPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public MasterAgreementClauseVariantBuilder addVariableSet(MasterAgreementVariableSet _variableSet) {
            if (_variableSet != null) {
                this.variableSet.add(_variableSet.toBuilder());
            }
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addVariableSet(MasterAgreementVariableSet _variableSet, int idx) {
            this.getIndex(this.variableSet, idx, () -> _variableSet.toBuilder());
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder addVariableSet(List<? extends MasterAgreementVariableSet> variableSets) {
            if (variableSets != null) {
                for (MasterAgreementVariableSet masterAgreementVariableSet : variableSets) {
                    this.variableSet.add(masterAgreementVariableSet.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="variableSet")
        public MasterAgreementClauseVariantBuilder setVariableSet(List<? extends MasterAgreementVariableSet> variableSets) {
            this.variableSet = variableSets == null ? new ArrayList<MasterAgreementVariableSet.MasterAgreementVariableSetBuilder>() : (List)variableSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MasterAgreementClauseVariant build() {
            return new MasterAgreementClauseVariantImpl(this);
        }

        @Override
        public MasterAgreementClauseVariantBuilder toBuilder() {
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder prune() {
            this.variableSet = this.variableSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null) {
                return true;
            }
            if (this.getName() != null) {
                return true;
            }
            if (this.getCounterparty() != null && !this.getCounterparty().isEmpty()) {
                return true;
            }
            if (this.getOtherParty() != null && !this.getOtherParty().isEmpty()) {
                return true;
            }
            return this.getVariableSet() != null && this.getVariableSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MasterAgreementClauseVariantBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MasterAgreementClauseVariantBuilder o = (MasterAgreementClauseVariantBuilder)other;
            merger.mergeRosetta(this.getVariableSet(), o.getVariableSet(), this::getOrCreateVariableSet);
            merger.mergeBasic((Object)this.getIdentifier(), (Object)o.getIdentifier(), this::setIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic(this.getCounterparty(), o.getCounterparty(), this::addCounterparty);
            merger.mergeBasic(this.getOtherParty(), o.getOtherParty(), this::addOtherParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreementClauseVariant _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.identifier, (Object)_that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.variableSet, _that.getVariableSet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? ((Object)((Object)this.identifier)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreementClauseVariantBuilder {identifier=" + (Object)((Object)this.identifier) + ", name=" + this.name + ", counterparty=" + this.counterparty + ", otherParty=" + this.otherParty + ", variableSet=" + this.variableSet + '}';
        }
    }

    public static interface MasterAgreementClauseVariantBuilder
    extends MasterAgreementClauseVariant,
    RosettaModelObjectBuilder {
        public MasterAgreementVariableSet.MasterAgreementVariableSetBuilder getOrCreateVariableSet(int var1);

        public List<? extends MasterAgreementVariableSet.MasterAgreementVariableSetBuilder> getVariableSet();

        public MasterAgreementClauseVariantBuilder setIdentifier(MasterAgreementVariantIdentifierEnum var1);

        public MasterAgreementClauseVariantBuilder setName(String var1);

        public MasterAgreementClauseVariantBuilder addCounterparty(CounterpartyRoleEnum var1);

        public MasterAgreementClauseVariantBuilder addCounterparty(CounterpartyRoleEnum var1, int var2);

        public MasterAgreementClauseVariantBuilder addCounterparty(List<CounterpartyRoleEnum> var1);

        public MasterAgreementClauseVariantBuilder setCounterparty(List<CounterpartyRoleEnum> var1);

        public MasterAgreementClauseVariantBuilder addOtherParty(PartyRoleEnum var1);

        public MasterAgreementClauseVariantBuilder addOtherParty(PartyRoleEnum var1, int var2);

        public MasterAgreementClauseVariantBuilder addOtherParty(List<PartyRoleEnum> var1);

        public MasterAgreementClauseVariantBuilder setOtherParty(List<PartyRoleEnum> var1);

        public MasterAgreementClauseVariantBuilder addVariableSet(MasterAgreementVariableSet var1);

        public MasterAgreementClauseVariantBuilder addVariableSet(MasterAgreementVariableSet var1, int var2);

        public MasterAgreementClauseVariantBuilder addVariableSet(List<? extends MasterAgreementVariableSet> var1);

        public MasterAgreementClauseVariantBuilder setVariableSet(List<? extends MasterAgreementVariableSet> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("identifier"), MasterAgreementVariantIdentifierEnum.class, (Object)this.getIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty"), CounterpartyRoleEnum.class, this.getCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherParty"), PartyRoleEnum.class, this.getOtherParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("variableSet"), processor, MasterAgreementVariableSet.MasterAgreementVariableSetBuilder.class, this.getVariableSet(), new AttributeMeta[0]);
        }

        public MasterAgreementClauseVariantBuilder prune();
    }

    public static class MasterAgreementClauseVariantImpl
    implements MasterAgreementClauseVariant {
        private final MasterAgreementVariantIdentifierEnum identifier;
        private final String name;
        private final List<CounterpartyRoleEnum> counterparty;
        private final List<PartyRoleEnum> otherParty;
        private final List<? extends MasterAgreementVariableSet> variableSet;

        protected MasterAgreementClauseVariantImpl(MasterAgreementClauseVariantBuilder builder) {
            this.identifier = builder.getIdentifier();
            this.name = builder.getName();
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.otherParty = Optional.ofNullable(builder.getOtherParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.variableSet = Optional.ofNullable(builder.getVariableSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public MasterAgreementVariantIdentifierEnum getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="counterparty")
        @RuneAttribute(value="counterparty")
        public List<CounterpartyRoleEnum> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public List<PartyRoleEnum> getOtherParty() {
            return this.otherParty;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public List<? extends MasterAgreementVariableSet> getVariableSet() {
            return this.variableSet;
        }

        @Override
        public MasterAgreementClauseVariant build() {
            return this;
        }

        @Override
        public MasterAgreementClauseVariantBuilder toBuilder() {
            MasterAgreementClauseVariantBuilder builder = MasterAgreementClauseVariant.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MasterAgreementClauseVariantBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getOtherParty()).ifPresent(builder::setOtherParty);
            Optional.ofNullable(this.getVariableSet()).ifPresent(builder::setVariableSet);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreementClauseVariant _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.identifier, (Object)_that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.variableSet, _that.getVariableSet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? ((Object)((Object)this.identifier)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreementClauseVariant {identifier=" + (Object)((Object)this.identifier) + ", name=" + this.name + ", counterparty=" + this.counterparty + ", otherParty=" + this.otherParty + ", variableSet=" + this.variableSet + '}';
        }
    }
}

