/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.Exposure;
import cdm.event.common.MarginCallBase;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallExposureMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MarginCallExposure", builder=MarginCallExposureBuilderImpl.class, version="5.28.0")
@RuneDataType(value="MarginCallExposure", model="cdm", builder=MarginCallExposureBuilderImpl.class, version="5.28.0")
public interface MarginCallExposure
extends MarginCallBase {
    public static final MarginCallExposureMeta metaData = new MarginCallExposureMeta();

    public Exposure getOverallExposure();

    public Exposure getSimmIMExposure();

    public Exposure getScheduleGridIMExposure();

    @Override
    public MarginCallExposure build();

    @Override
    public MarginCallExposureBuilder toBuilder();

    public static MarginCallExposureBuilder builder() {
        return new MarginCallExposureBuilderImpl();
    }

    default public RosettaMetaData<? extends MarginCallExposure> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MarginCallExposure> getType() {
        return MarginCallExposure.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.class, this.getInstructionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.class, this.getClearingBroker(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.class, this.getCallIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.class, this.getCallAgreementType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.class, this.getAgreementThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.class, this.getAgreementRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("overallExposure"), processor, Exposure.class, this.getOverallExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simmIMExposure"), processor, Exposure.class, this.getSimmIMExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scheduleGridIMExposure"), processor, Exposure.class, this.getScheduleGridIMExposure(), new AttributeMeta[0]);
    }

    public static class MarginCallExposureBuilderImpl
    extends MarginCallBase.MarginCallBaseBuilderImpl
    implements MarginCallExposureBuilder {
        protected Exposure.ExposureBuilder overallExposure;
        protected Exposure.ExposureBuilder simmIMExposure;
        protected Exposure.ExposureBuilder scheduleGridIMExposure;

        @Override
        @RosettaAttribute(value="overallExposure", isRequired=true)
        @RuneAttribute(value="overallExposure", isRequired=true)
        public Exposure.ExposureBuilder getOverallExposure() {
            return this.overallExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateOverallExposure() {
            Exposure.ExposureBuilder result = this.overallExposure != null ? this.overallExposure : (this.overallExposure = Exposure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="simmIMExposure")
        @RuneAttribute(value="simmIMExposure")
        public Exposure.ExposureBuilder getSimmIMExposure() {
            return this.simmIMExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateSimmIMExposure() {
            Exposure.ExposureBuilder result = this.simmIMExposure != null ? this.simmIMExposure : (this.simmIMExposure = Exposure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="scheduleGridIMExposure")
        @RuneAttribute(value="scheduleGridIMExposure")
        public Exposure.ExposureBuilder getScheduleGridIMExposure() {
            return this.scheduleGridIMExposure;
        }

        @Override
        public Exposure.ExposureBuilder getOrCreateScheduleGridIMExposure() {
            Exposure.ExposureBuilder result = this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure : (this.scheduleGridIMExposure = Exposure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="instructionType", isRequired=true)
        @RuneAttribute(value="instructionType", isRequired=true)
        public MarginCallExposureBuilder setInstructionType(MarginCallInstructionType _instructionType) {
            this.instructionType = _instructionType == null ? null : _instructionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public MarginCallExposureBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public MarginCallExposureBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public MarginCallExposureBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public MarginCallExposureBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole _partyRole, int idx) {
            this.getIndex(this.partyRole, idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallExposureBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public MarginCallExposureBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        @RuneAttribute(value="clearingBroker")
        public MarginCallExposureBuilder setClearingBroker(Party _clearingBroker) {
            this.clearingBroker = _clearingBroker == null ? null : _clearingBroker.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        @RuneAttribute(value="callIdentifier")
        public MarginCallExposureBuilder setCallIdentifier(Identifier _callIdentifier) {
            this.callIdentifier = _callIdentifier == null ? null : _callIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callAgreementType", isRequired=true)
        @RuneAttribute(value="callAgreementType", isRequired=true)
        public MarginCallExposureBuilder setCallAgreementType(AgreementName _callAgreementType) {
            this.callAgreementType = _callAgreementType == null ? null : _callAgreementType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        @RuneAttribute(value="agreementMinimumTransferAmount")
        public MarginCallExposureBuilder setAgreementMinimumTransferAmount(Money _agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = _agreementMinimumTransferAmount == null ? null : _agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        @RuneAttribute(value="agreementThreshold")
        public MarginCallExposureBuilder setAgreementThreshold(Money _agreementThreshold) {
            this.agreementThreshold = _agreementThreshold == null ? null : _agreementThreshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        @RuneAttribute(value="agreementRounding")
        public MarginCallExposureBuilder setAgreementRounding(Money _agreementRounding) {
            this.agreementRounding = _agreementRounding == null ? null : _agreementRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regMarginType", isRequired=true)
        @RuneAttribute(value="regMarginType", isRequired=true)
        public MarginCallExposureBuilder setRegMarginType(RegMarginTypeEnum _regMarginType) {
            this.regMarginType = _regMarginType == null ? null : _regMarginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        @RuneAttribute(value="regIMRole")
        public MarginCallExposureBuilder setRegIMRole(RegIMRoleEnum _regIMRole) {
            this.regIMRole = _regIMRole == null ? null : _regIMRole;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        @RuneAttribute(value="baseCurrencyExposure")
        public MarginCallExposureBuilder setBaseCurrencyExposure(MarginCallExposure _baseCurrencyExposure) {
            this.baseCurrencyExposure = _baseCurrencyExposure == null ? null : _baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public MarginCallExposureBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio _collateralPortfolio) {
            this.collateralPortfolio = _collateralPortfolio == null ? null : _collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposureBuilder setCollateralPortfolioValue(CollateralPortfolio _collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(_collateralPortfolio);
            return this;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        @RuneAttribute(value="independentAmountBalance")
        public MarginCallExposureBuilder setIndependentAmountBalance(CollateralBalance _independentAmountBalance) {
            this.independentAmountBalance = _independentAmountBalance == null ? null : _independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="overallExposure", isRequired=true)
        @RuneAttribute(value="overallExposure", isRequired=true)
        public MarginCallExposureBuilder setOverallExposure(Exposure _overallExposure) {
            this.overallExposure = _overallExposure == null ? null : _overallExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="simmIMExposure")
        @RuneAttribute(value="simmIMExposure")
        public MarginCallExposureBuilder setSimmIMExposure(Exposure _simmIMExposure) {
            this.simmIMExposure = _simmIMExposure == null ? null : _simmIMExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduleGridIMExposure")
        @RuneAttribute(value="scheduleGridIMExposure")
        public MarginCallExposureBuilder setScheduleGridIMExposure(Exposure _scheduleGridIMExposure) {
            this.scheduleGridIMExposure = _scheduleGridIMExposure == null ? null : _scheduleGridIMExposure.toBuilder();
            return this;
        }

        @Override
        public MarginCallExposure build() {
            return new MarginCallExposureImpl(this);
        }

        @Override
        public MarginCallExposureBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallExposureBuilder prune() {
            super.prune();
            if (this.overallExposure != null && !this.overallExposure.prune().hasData()) {
                this.overallExposure = null;
            }
            if (this.simmIMExposure != null && !this.simmIMExposure.prune().hasData()) {
                this.simmIMExposure = null;
            }
            if (this.scheduleGridIMExposure != null && !this.scheduleGridIMExposure.prune().hasData()) {
                this.scheduleGridIMExposure = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOverallExposure() != null && this.getOverallExposure().hasData()) {
                return true;
            }
            if (this.getSimmIMExposure() != null && this.getSimmIMExposure().hasData()) {
                return true;
            }
            return this.getScheduleGridIMExposure() != null && this.getScheduleGridIMExposure().hasData();
        }

        @Override
        public MarginCallExposureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MarginCallExposureBuilder o = (MarginCallExposureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOverallExposure(), (RosettaModelObjectBuilder)o.getOverallExposure(), this::setOverallExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimmIMExposure(), (RosettaModelObjectBuilder)o.getSimmIMExposure(), this::setSimmIMExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getScheduleGridIMExposure(), (RosettaModelObjectBuilder)o.getScheduleGridIMExposure(), this::setScheduleGridIMExposure);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallExposure _that = (MarginCallExposure)this.getType().cast(o);
            if (!Objects.equals(this.overallExposure, _that.getOverallExposure())) {
                return false;
            }
            if (!Objects.equals(this.simmIMExposure, _that.getSimmIMExposure())) {
                return false;
            }
            return Objects.equals(this.scheduleGridIMExposure, _that.getScheduleGridIMExposure());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.overallExposure != null ? this.overallExposure.hashCode() : 0);
            _result = 31 * _result + (this.simmIMExposure != null ? this.simmIMExposure.hashCode() : 0);
            _result = 31 * _result + (this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallExposureBuilder {overallExposure=" + this.overallExposure + ", simmIMExposure=" + this.simmIMExposure + ", scheduleGridIMExposure=" + this.scheduleGridIMExposure + '}' + " " + super.toString();
        }
    }

    public static interface MarginCallExposureBuilder
    extends MarginCallExposure,
    MarginCallBase.MarginCallBaseBuilder {
        public Exposure.ExposureBuilder getOrCreateOverallExposure();

        @Override
        public Exposure.ExposureBuilder getOverallExposure();

        public Exposure.ExposureBuilder getOrCreateSimmIMExposure();

        @Override
        public Exposure.ExposureBuilder getSimmIMExposure();

        public Exposure.ExposureBuilder getOrCreateScheduleGridIMExposure();

        @Override
        public Exposure.ExposureBuilder getScheduleGridIMExposure();

        @Override
        public MarginCallExposureBuilder setInstructionType(MarginCallInstructionType var1);

        @Override
        public MarginCallExposureBuilder addParty(Party var1);

        @Override
        public MarginCallExposureBuilder addParty(Party var1, int var2);

        @Override
        public MarginCallExposureBuilder addParty(List<? extends Party> var1);

        @Override
        public MarginCallExposureBuilder setParty(List<? extends Party> var1);

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole var1);

        @Override
        public MarginCallExposureBuilder addPartyRole(PartyRole var1, int var2);

        @Override
        public MarginCallExposureBuilder addPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallExposureBuilder setPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallExposureBuilder setClearingBroker(Party var1);

        @Override
        public MarginCallExposureBuilder setCallIdentifier(Identifier var1);

        @Override
        public MarginCallExposureBuilder setCallAgreementType(AgreementName var1);

        @Override
        public MarginCallExposureBuilder setAgreementMinimumTransferAmount(Money var1);

        @Override
        public MarginCallExposureBuilder setAgreementThreshold(Money var1);

        @Override
        public MarginCallExposureBuilder setAgreementRounding(Money var1);

        @Override
        public MarginCallExposureBuilder setRegMarginType(RegMarginTypeEnum var1);

        @Override
        public MarginCallExposureBuilder setRegIMRole(RegIMRoleEnum var1);

        @Override
        public MarginCallExposureBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        @Override
        public MarginCallExposureBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        @Override
        public MarginCallExposureBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        @Override
        public MarginCallExposureBuilder setIndependentAmountBalance(CollateralBalance var1);

        public MarginCallExposureBuilder setOverallExposure(Exposure var1);

        public MarginCallExposureBuilder setSimmIMExposure(Exposure var1);

        public MarginCallExposureBuilder setScheduleGridIMExposure(Exposure var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.MarginCallInstructionTypeBuilder.class, (RosettaModelObjectBuilder)this.getInstructionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.PartyBuilder.class, (RosettaModelObjectBuilder)this.getClearingBroker(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.IdentifierBuilder.class, (RosettaModelObjectBuilder)this.getCallIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.AgreementNameBuilder.class, (RosettaModelObjectBuilder)this.getCallAgreementType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposureBuilder.class, (RosettaModelObjectBuilder)this.getBaseCurrencyExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, (RosettaModelObjectBuilder)this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, (RosettaModelObjectBuilder)this.getIndependentAmountBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("overallExposure"), processor, Exposure.ExposureBuilder.class, this.getOverallExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simmIMExposure"), processor, Exposure.ExposureBuilder.class, this.getSimmIMExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scheduleGridIMExposure"), processor, Exposure.ExposureBuilder.class, this.getScheduleGridIMExposure(), new AttributeMeta[0]);
        }

        @Override
        public MarginCallExposureBuilder prune();
    }

    public static class MarginCallExposureImpl
    extends MarginCallBase.MarginCallBaseImpl
    implements MarginCallExposure {
        private final Exposure overallExposure;
        private final Exposure simmIMExposure;
        private final Exposure scheduleGridIMExposure;

        protected MarginCallExposureImpl(MarginCallExposureBuilder builder) {
            super(builder);
            this.overallExposure = Optional.ofNullable(builder.getOverallExposure()).map(f -> f.build()).orElse(null);
            this.simmIMExposure = Optional.ofNullable(builder.getSimmIMExposure()).map(f -> f.build()).orElse(null);
            this.scheduleGridIMExposure = Optional.ofNullable(builder.getScheduleGridIMExposure()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="overallExposure", isRequired=true)
        @RuneAttribute(value="overallExposure", isRequired=true)
        public Exposure getOverallExposure() {
            return this.overallExposure;
        }

        @Override
        @RosettaAttribute(value="simmIMExposure")
        @RuneAttribute(value="simmIMExposure")
        public Exposure getSimmIMExposure() {
            return this.simmIMExposure;
        }

        @Override
        @RosettaAttribute(value="scheduleGridIMExposure")
        @RuneAttribute(value="scheduleGridIMExposure")
        public Exposure getScheduleGridIMExposure() {
            return this.scheduleGridIMExposure;
        }

        @Override
        public MarginCallExposure build() {
            return this;
        }

        @Override
        public MarginCallExposureBuilder toBuilder() {
            MarginCallExposureBuilder builder = MarginCallExposure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallExposureBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOverallExposure()).ifPresent(builder::setOverallExposure);
            Optional.ofNullable(this.getSimmIMExposure()).ifPresent(builder::setSimmIMExposure);
            Optional.ofNullable(this.getScheduleGridIMExposure()).ifPresent(builder::setScheduleGridIMExposure);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallExposure _that = (MarginCallExposure)this.getType().cast(o);
            if (!Objects.equals(this.overallExposure, _that.getOverallExposure())) {
                return false;
            }
            if (!Objects.equals(this.simmIMExposure, _that.getSimmIMExposure())) {
                return false;
            }
            return Objects.equals(this.scheduleGridIMExposure, _that.getScheduleGridIMExposure());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.overallExposure != null ? this.overallExposure.hashCode() : 0);
            _result = 31 * _result + (this.simmIMExposure != null ? this.simmIMExposure.hashCode() : 0);
            _result = 31 * _result + (this.scheduleGridIMExposure != null ? this.scheduleGridIMExposure.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallExposure {overallExposure=" + this.overallExposure + ", simmIMExposure=" + this.simmIMExposure + ", scheduleGridIMExposure=" + this.scheduleGridIMExposure + '}' + " " + super.toString();
        }
    }
}

