# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['OptionPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class OptionPayout(PayoutBase):
  """
   The option payout specification terms. The associated globalKey denotes the ability to associate a hash value to the respective OptionPayout instantiation for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
  """
  buyerSeller: BuyerSeller = Field(..., description="")
  optionType: Optional[OptionTypeEnum] = Field(None, description="The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.")
  """
  The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.
  """
  feature: Optional[OptionFeature] = Field(None, description="The option feature, such as quanto, Asian, barrier, knock.")
  """
  The option feature, such as quanto, Asian, barrier, knock.
  """
  exerciseTerms: OptionExercise = Field(..., description="The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).")
  """
  The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
  """
  underlier: Product = Field(..., description="The product underlying the option, which can be of any type including ContractualProduct or Security.")
  """
  The product underlying the option, which can be of any type including ContractualProduct or Security.
  """
  observationTerms: Optional[ObservationTerms] = Field(None, description="Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.")
  """
  Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.
  """
  schedule: Optional[CalculationSchedule] = Field(None, description="Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.")
  """
  Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
  """
  delivery: Optional[AssetDeliveryInformation] = Field(None, description="Contains the information relative to the delivery of the asset.")
  """
  Contains the information relative to the delivery of the asset.
  """
  
  @rosetta_condition
  def condition_0_ClearedPhysicalSettlementExists(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "settlementTerms"), "physicalSettlementTerms"), "clearedPhysicalSettlement")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "settlementTerms"), "physicalSettlementTerms")) is not None) and self.check_one_of_constraint(self, _resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "contractualProduct"), "economicTerms"), "payout"), "interestRatePayout"))) and all_elements(len(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "underlier"), "contractualProduct"), "economicTerms"), "payout"), "interestRatePayout")), "=", 2)), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_DeliveryCapacity(self):
    """
    Checks that only one of the representations of delivery capacity is present simultaneously.
    """
    def _then_fn3():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn3():
      return True
    
    def _then_fn2():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn2():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is not None), _then_fn3, _else_fn3)
    
    def _then_fn1():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn1():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is not None), _then_fn2, _else_fn2)
    
    def _then_fn0():
      return ((((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")) is None)) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")) is None))
    
    def _else_fn0():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")) is not None), _then_fn1, _else_fn1)
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "deliveryCapacity")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_2_PriceTimeIntervalQuantity(self):
    """
    Checks that only one of the representations of price time interval quantity is present simultaneously.
    """
    def _then_fn2():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn2():
      return True
    
    def _then_fn1():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn1():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is not None), _then_fn2, _else_fn2)
    
    def _then_fn0():
      return (((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is None) and ((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")) is None))
    
    def _else_fn0():
      return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")) is not None), _then_fn1, _else_fn1)
    
    return if_cond_fn(((_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")) is not None), _then_fn0, _else_fn0)

from cdm.base.staticdata.party.BuyerSeller import BuyerSeller
from cdm.product.template.OptionTypeEnum import OptionTypeEnum
from cdm.product.template.OptionFeature import OptionFeature
from cdm.product.template.OptionExercise import OptionExercise
from cdm.product.template.Product import Product
from cdm.product.common.schedule.ObservationTerms import ObservationTerms
from cdm.product.template.CalculationSchedule import CalculationSchedule
from cdm.product.asset.AssetDeliveryInformation import AssetDeliveryInformation

OptionPayout.update_forward_refs()
