# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['EligibilityQuery']


class EligibilityQuery(BaseDataClass):
  """
  Query to check against an EligibleCollateralSpecification
  """
  maturity: Decimal = Field(..., description="Maturity in years")
  """
  Maturity in years
  """
  collateralAssetType: AssetType = Field(..., description="The asset product type.")
  """
  The asset product type.
  """
  assetCountryOfOrigin: ISOCountryCodeEnum = Field(..., description="The asset country of origin.")
  """
  The asset country of origin.
  """
  denominatedCurrency: CurrencyCodeEnum = Field(..., description="The underlying asset denominated currency.")
  """
  The underlying asset denominated currency.
  """
  agencyRating: AgencyRatingCriteria = Field(..., description="The agency rating based on default risk and creditors claim in event of default associated with specific instrument.")
  """
  The agency rating based on default risk and creditors claim in event of default associated with specific instrument.
  """
  issuerType: CollateralIssuerType = Field(..., description="Represents a filter based on the type of entity issuing the asset.")
  """
  Represents a filter based on the type of entity issuing the asset.
  """
  issuerName: LegalEntity = Field(..., description="Specifies the issuing entity name or LEI.")
  """
  Specifies the issuing entity name or LEI.
  """

from cdm.base.staticdata.asset.common.AssetType import AssetType
from cdm.base.staticdata.asset.common.ISOCountryCodeEnum import ISOCountryCodeEnum
from cdm.base.staticdata.asset.common.CurrencyCodeEnum import CurrencyCodeEnum
from cdm.product.collateral.AgencyRatingCriteria import AgencyRatingCriteria
from cdm.base.staticdata.asset.common.CollateralIssuerType import CollateralIssuerType
from cdm.base.staticdata.party.LegalEntity import LegalEntity

EligibilityQuery.update_forward_refs()
