# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CheckEligibilityResult']


class CheckEligibilityResult(BaseDataClass):
  """
  Result for the CheckEligibilityByDetails and CheckEligibilityForProduct functions
  """
  isEligible: bool = Field(..., description="True if the asset is eligible")
  """
  True if the asset is eligible
  """
  matchingEligibleCriteria: List[EligibleCollateralCriteria] = Field([], description="Eligible Collateral Criteria that matched the eligibility query")
  """
  Eligible Collateral Criteria that matched the eligibility query
  """
  @rosetta_condition
  def cardinality_matchingEligibleCriteria(self):
    return check_cardinality(self.matchingEligibleCriteria, 1, None)
  
  eligibilityQuery: Optional[EligibilityQuery] = Field(None, description="eligibility query was was checked against the eligible collateral specification")
  """
  eligibility query was was checked against the eligible collateral specification
  """
  specification: EligibleCollateralSpecification = Field(..., description="The eligible collateral specification that was queried")
  """
  The eligible collateral specification that was queried
  """

from cdm.product.collateral.EligibleCollateralCriteria import EligibleCollateralCriteria
from cdm.product.collateral.EligibilityQuery import EligibilityQuery
from cdm.product.collateral.EligibleCollateralSpecification import EligibleCollateralSpecification

CheckEligibilityResult.update_forward_refs()
