# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['AssetDeliveryProfileBlock']


class AssetDeliveryProfileBlock(BaseDataClass):
  """
  Defines a delivery profile block, including start and end time, days of the week, duration, delivery capacity and price time interval quantity.
  """
  startTime: Optional[time] = Field(None, description="The start time of the delivery interval for each block or shape.")
  """
  The start time of the delivery interval for each block or shape.
  """
  endTime: Optional[time] = Field(None, description="The end time of the delivery interval for each block or shape.")
  """
  The end time of the delivery interval for each block or shape.
  """
  dayOfWeek: List[DayOfWeekEnum] = Field([], description="The days of the week of the delivery.")
  """
  The days of the week of the delivery.
  """
  @rosetta_condition
  def cardinality_dayOfWeek(self):
    return check_cardinality(self.dayOfWeek, 0, 7)
  
  deliveryCapacity: Optional[Quantity] = Field(None, description="The number of units included in the transaction for each delivery interval")
  """
  The number of units included in the transaction for each delivery interval
  """
  priceTimeIntervalQuantity: Optional[Price] = Field(None, description="Price per quantity per delivery time interval.")
  """
  Price per quantity per delivery time interval.
  """

from cdm.base.datetime.DayOfWeekEnum import DayOfWeekEnum
from cdm.base.math.Quantity import Quantity
from cdm.observable.asset.Price import Price

AssetDeliveryProfileBlock.update_forward_refs()
