# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['Clause']


class Clause(BaseDataClass):
  """
  A type for documenting additional clause that cannot yet be represented with the model and yet needed for a digital representation of the agreement
  """
  identifier: Optional[str] = Field(None, description="The name or identifier associated to this clause ")
  """
  The  name or identifier associated to this clause 
  """
  terms: Optional[str] = Field(None, description="Content of this bespoke clause")
  """
  Content of this bespoke clause
  """
  subcomponents: List[Clause] = Field([], description="Additional hierarchichal components of the clause if relevant")
  """
  Additional hierarchichal components of the clause if relevant
  """
  
  @rosetta_condition
  def condition_0_(self):
    """
    The Clause should describe at least the additional terms,  additional subcomponents or both
    """
    return self.check_one_of_constraint('terms', 'subcomponents', necessity=False)

from cdm.legaldocumentation.master.Clause import Clause

Clause.update_forward_refs()
