/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ProductOneOf0")
@ImplementedBy(value=Default.class)
public interface ProductOneOf0
extends Validator<Product> {
    public static final String NAME = "ProductOneOf0";
    public static final String DEFINITION = "one-of";

    public ValidationResult<Product> validate(RosettaPath var1, Product var2);

    public static class NoOp
    implements ProductOneOf0 {
        @Override
        public ValidationResult<Product> validate(RosettaPath path, Product product) {
            return ValidationResult.success((String)ProductOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductOneOf0.DEFINITION);
        }
    }

    public static class Default
    implements ProductOneOf0 {
        @Override
        public ValidationResult<Product> validate(RosettaPath path, Product product) {
            ComparisonResult result = this.executeDataRule(product);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ProductOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductOneOf0.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ProductOneOf0 failed.";
            }
            return ValidationResult.failure((String)ProductOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductOneOf0.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Product product) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)product), Arrays.asList("contractualProduct", "index", "loan", "assetPool", "foreignExchange", "commodity", "security", "basket"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

