/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ContractualProductPrimaryAssetClass")
@ImplementedBy(value=Default.class)
public interface ContractualProductPrimaryAssetClass
extends Validator<ContractualProduct> {
    public static final String NAME = "ContractualProductPrimaryAssetClass";
    public static final String DEFINITION = "if economicTerms -> nonStandardisedTerms = True then productTaxonomy -> primaryAssetClass exists";

    public ValidationResult<ContractualProduct> validate(RosettaPath var1, ContractualProduct var2);

    public static class NoOp
    implements ContractualProductPrimaryAssetClass {
        @Override
        public ValidationResult<ContractualProduct> validate(RosettaPath path, ContractualProduct contractualProduct) {
            return ValidationResult.success((String)ContractualProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractualProduct", (RosettaPath)path, (String)ContractualProductPrimaryAssetClass.DEFINITION);
        }
    }

    public static class Default
    implements ContractualProductPrimaryAssetClass {
        @Override
        public ValidationResult<ContractualProduct> validate(RosettaPath path, ContractualProduct contractualProduct) {
            ComparisonResult result = this.executeDataRule(contractualProduct);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ContractualProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractualProduct", (RosettaPath)path, (String)ContractualProductPrimaryAssetClass.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ContractualProductPrimaryAssetClass failed.";
            }
            return ValidationResult.failure((String)ContractualProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractualProduct", (RosettaPath)path, (String)ContractualProductPrimaryAssetClass.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ContractualProduct contractualProduct) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)contractualProduct).map("getEconomicTerms", _contractualProduct -> _contractualProduct.getEconomicTerms()).map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)contractualProduct).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("getValue", _f -> _f.getValue()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

