/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.validation.datarule;

import cdm.product.collateral.Collateral;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CollateralCollateralExists")
@ImplementedBy(value=Default.class)
public interface CollateralCollateralExists
extends Validator<Collateral> {
    public static final String NAME = "CollateralCollateralExists";
    public static final String DEFINITION = "independentAmount exists or collateralPortfolio exists";

    public ValidationResult<Collateral> validate(RosettaPath var1, Collateral var2);

    public static class NoOp
    implements CollateralCollateralExists {
        @Override
        public ValidationResult<Collateral> validate(RosettaPath path, Collateral collateral) {
            return ValidationResult.success((String)CollateralCollateralExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Collateral", (RosettaPath)path, (String)CollateralCollateralExists.DEFINITION);
        }
    }

    public static class Default
    implements CollateralCollateralExists {
        @Override
        public ValidationResult<Collateral> validate(RosettaPath path, Collateral collateral) {
            ComparisonResult result = this.executeDataRule(collateral);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CollateralCollateralExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Collateral", (RosettaPath)path, (String)CollateralCollateralExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CollateralCollateralExists failed.";
            }
            return ValidationResult.failure((String)CollateralCollateralExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Collateral", (RosettaPath)path, (String)CollateralCollateralExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Collateral collateral) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)collateral).map("getIndependentAmount", _collateral -> _collateral.getIndependentAmount())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)collateral).mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

