/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event.functions;

import cdm.base.math.UnitType;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.event.Observation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveObservationAverageDefault.class)
public abstract class ResolveObservationAverage
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public Price evaluate(List<? extends Observation> observations) {
        Price resetValue;
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperC.of((List)observations).map("getObservedValue", observation -> observation.getObservedValue()).map("getUnit", measureBase -> measureBase.getUnit()), (Mapper)MapperS.of((Object)((Price)this.firstObservedValue(observations).get())).map("getUnit", measureBase -> measureBase.getUnit()), (CardinalityOperator)CardinalityOperator.All), "");
        Price.PriceBuilder resetValueBuilder = this.doEvaluate(observations);
        if (resetValueBuilder == null) {
            resetValue = null;
        } else {
            resetValue = resetValueBuilder.build();
            this.objectValidator.validate(Price.class, (RosettaModelObject)resetValue);
        }
        return resetValue;
    }

    protected abstract Price.PriceBuilder doEvaluate(List<? extends Observation> var1);

    protected abstract Mapper<? extends Price> firstObservedValue(List<? extends Observation> var1);

    public static class ResolveObservationAverageDefault
    extends ResolveObservationAverage {
        @Override
        protected Price.PriceBuilder doEvaluate(List<? extends Observation> observations) {
            Price.PriceBuilder resetValue = Price.builder();
            return this.assignOutput(resetValue, observations);
        }

        protected Price.PriceBuilder assignOutput(Price.PriceBuilder resetValue, List<? extends Observation> observations) {
            resetValue.setValue((BigDecimal)MapperMaths.divide((Mapper)MapperC.of(observations).map("getObservedValue", observation -> observation.getObservedValue()).map("getValue", measureBase -> measureBase.getValue()).sumBigDecimal(), (Mapper)MapperS.of((Object)MapperC.of(observations).resultCount())).get());
            resetValue.setUnit((UnitType)MapperS.of((Object)((Price)this.firstObservedValue(observations).get())).map("getUnit", measureBase -> measureBase.getUnit()).get());
            resetValue.setPerUnitOf((UnitType)MapperS.of((Object)((Price)this.firstObservedValue(observations).get())).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get());
            resetValue.setPriceExpression((PriceExpressionEnum)((Object)MapperS.of((Object)((Price)this.firstObservedValue(observations).get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get()));
            resetValue.setPriceType((PriceTypeEnum)((Object)MapperS.of((Object)((Price)this.firstObservedValue(observations).get())).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get()));
            return Optional.ofNullable(resetValue).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends Price> firstObservedValue(List<? extends Observation> observations) {
            return MapperC.of(observations).map("getObservedValue", observation -> observation.getObservedValue()).first();
        }
    }
}

