/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FeeTypeEnum")
public enum FeeTypeEnum {
    ASSIGNMENT("Assignment"),
    BROKERAGE_COMMISSION("BrokerageCommission"),
    INCREASE("Increase"),
    NOVATION("Novation"),
    PARTIAL_TERMINATION("PartialTermination"),
    PREMIUM("Premium"),
    RENEGOTIATION("Renegotiation"),
    TERMINATION("Termination"),
    UPFRONT("Upfront"),
    CREDIT_EVENT("CreditEvent"),
    CORPORATE_ACTION("CorporateAction");

    private static Map<String, FeeTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FeeTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private FeeTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FeeTypeEnum fromDisplayName(String name) {
        FeeTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FeeTypeEnum> map = new ConcurrentHashMap<String, FeeTypeEnum>();
        for (FeeTypeEnum instance : FeeTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

