/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CreditRatingAgencyEnum;
import cdm.observable.asset.CreditRatingCreditWatchEnum;
import cdm.observable.asset.CreditRatingDebt;
import cdm.observable.asset.CreditRatingOutlookEnum;
import cdm.observable.asset.meta.CreditNotationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CreditNotation", builder=CreditNotationBuilderImpl.class, version="5.0.0")
public interface CreditNotation
extends RosettaModelObject {
    public static final CreditNotationMeta metaData = new CreditNotationMeta();

    public CreditRatingAgencyEnum getAgency();

    public FieldWithMetaString getNotation();

    public FieldWithMetaString getScale();

    public CreditRatingDebt getDebt();

    public CreditRatingOutlookEnum getOutlook();

    public CreditRatingCreditWatchEnum getCreditWatch();

    public CreditNotation build();

    public CreditNotationBuilder toBuilder();

    public static CreditNotationBuilder builder() {
        return new CreditNotationBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditNotation> metaData() {
        return metaData;
    }

    default public Class<? extends CreditNotation> getType() {
        return CreditNotation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("agency"), CreditRatingAgencyEnum.class, (Object)this.getAgency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("outlook"), CreditRatingOutlookEnum.class, (Object)this.getOutlook(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditWatch"), CreditRatingCreditWatchEnum.class, (Object)this.getCreditWatch(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notation"), processor, FieldWithMetaString.class, this.getNotation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scale"), processor, FieldWithMetaString.class, this.getScale(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("debt"), processor, CreditRatingDebt.class, this.getDebt(), new AttributeMeta[0]);
    }

    public static class CreditNotationBuilderImpl
    implements CreditNotationBuilder {
        protected CreditRatingAgencyEnum agency;
        protected FieldWithMetaString.FieldWithMetaStringBuilder notation;
        protected FieldWithMetaString.FieldWithMetaStringBuilder scale;
        protected CreditRatingDebt.CreditRatingDebtBuilder debt;
        protected CreditRatingOutlookEnum outlook;
        protected CreditRatingCreditWatchEnum creditWatch;

        @Override
        @RosettaAttribute(value="agency")
        public CreditRatingAgencyEnum getAgency() {
            return this.agency;
        }

        @Override
        @RosettaAttribute(value="notation")
        public FieldWithMetaString.FieldWithMetaStringBuilder getNotation() {
            return this.notation;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateNotation() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.notation != null ? this.notation : (this.notation = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="scale")
        public FieldWithMetaString.FieldWithMetaStringBuilder getScale() {
            return this.scale;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateScale() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.scale != null ? this.scale : (this.scale = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="debt")
        public CreditRatingDebt.CreditRatingDebtBuilder getDebt() {
            return this.debt;
        }

        @Override
        public CreditRatingDebt.CreditRatingDebtBuilder getOrCreateDebt() {
            CreditRatingDebt.CreditRatingDebtBuilder result = this.debt != null ? this.debt : (this.debt = CreditRatingDebt.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="outlook")
        public CreditRatingOutlookEnum getOutlook() {
            return this.outlook;
        }

        @Override
        @RosettaAttribute(value="creditWatch")
        public CreditRatingCreditWatchEnum getCreditWatch() {
            return this.creditWatch;
        }

        @Override
        @RosettaAttribute(value="agency")
        public CreditNotationBuilder setAgency(CreditRatingAgencyEnum agency) {
            this.agency = agency == null ? null : agency;
            return this;
        }

        @Override
        @RosettaAttribute(value="notation")
        public CreditNotationBuilder setNotation(FieldWithMetaString notation) {
            this.notation = notation == null ? null : notation.toBuilder();
            return this;
        }

        @Override
        public CreditNotationBuilder setNotationValue(String notation) {
            this.getOrCreateNotation().setValue(notation);
            return this;
        }

        @Override
        @RosettaAttribute(value="scale")
        public CreditNotationBuilder setScale(FieldWithMetaString scale) {
            this.scale = scale == null ? null : scale.toBuilder();
            return this;
        }

        @Override
        public CreditNotationBuilder setScaleValue(String scale) {
            this.getOrCreateScale().setValue(scale);
            return this;
        }

        @Override
        @RosettaAttribute(value="debt")
        public CreditNotationBuilder setDebt(CreditRatingDebt debt) {
            this.debt = debt == null ? null : debt.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="outlook")
        public CreditNotationBuilder setOutlook(CreditRatingOutlookEnum outlook) {
            this.outlook = outlook == null ? null : outlook;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditWatch")
        public CreditNotationBuilder setCreditWatch(CreditRatingCreditWatchEnum creditWatch) {
            this.creditWatch = creditWatch == null ? null : creditWatch;
            return this;
        }

        @Override
        public CreditNotation build() {
            return new CreditNotationImpl(this);
        }

        @Override
        public CreditNotationBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditNotationBuilder prune() {
            if (this.notation != null && !this.notation.prune().hasData()) {
                this.notation = null;
            }
            if (this.scale != null && !this.scale.prune().hasData()) {
                this.scale = null;
            }
            if (this.debt != null && !this.debt.prune().hasData()) {
                this.debt = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAgency() != null) {
                return true;
            }
            if (this.getNotation() != null) {
                return true;
            }
            if (this.getScale() != null) {
                return true;
            }
            if (this.getDebt() != null && this.getDebt().hasData()) {
                return true;
            }
            if (this.getOutlook() != null) {
                return true;
            }
            return this.getCreditWatch() != null;
        }

        public CreditNotationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditNotationBuilder o = (CreditNotationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotation(), (RosettaModelObjectBuilder)o.getNotation(), this::setNotation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getScale(), (RosettaModelObjectBuilder)o.getScale(), this::setScale);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDebt(), (RosettaModelObjectBuilder)o.getDebt(), this::setDebt);
            merger.mergeBasic((Object)this.getAgency(), (Object)o.getAgency(), this::setAgency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOutlook(), (Object)o.getOutlook(), this::setOutlook, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCreditWatch(), (Object)o.getCreditWatch(), this::setCreditWatch, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditNotation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.agency, (Object)_that.getAgency())) {
                return false;
            }
            if (!Objects.equals(this.notation, _that.getNotation())) {
                return false;
            }
            if (!Objects.equals(this.scale, _that.getScale())) {
                return false;
            }
            if (!Objects.equals(this.debt, _that.getDebt())) {
                return false;
            }
            if (!Objects.equals((Object)this.outlook, (Object)_that.getOutlook())) {
                return false;
            }
            return Objects.equals((Object)this.creditWatch, (Object)_that.getCreditWatch());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agency != null ? ((Object)((Object)this.agency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notation != null ? this.notation.hashCode() : 0);
            _result = 31 * _result + (this.scale != null ? this.scale.hashCode() : 0);
            _result = 31 * _result + (this.debt != null ? this.debt.hashCode() : 0);
            _result = 31 * _result + (this.outlook != null ? ((Object)((Object)this.outlook)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditWatch != null ? ((Object)((Object)this.creditWatch)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditNotationBuilder {agency=" + (Object)((Object)this.agency) + ", notation=" + this.notation + ", scale=" + this.scale + ", debt=" + this.debt + ", outlook=" + (Object)((Object)this.outlook) + ", creditWatch=" + (Object)((Object)this.creditWatch) + '}';
        }
    }

    public static class CreditNotationImpl
    implements CreditNotation {
        private final CreditRatingAgencyEnum agency;
        private final FieldWithMetaString notation;
        private final FieldWithMetaString scale;
        private final CreditRatingDebt debt;
        private final CreditRatingOutlookEnum outlook;
        private final CreditRatingCreditWatchEnum creditWatch;

        protected CreditNotationImpl(CreditNotationBuilder builder) {
            this.agency = builder.getAgency();
            this.notation = Optional.ofNullable(builder.getNotation()).map(f -> f.build()).orElse(null);
            this.scale = Optional.ofNullable(builder.getScale()).map(f -> f.build()).orElse(null);
            this.debt = Optional.ofNullable(builder.getDebt()).map(f -> f.build()).orElse(null);
            this.outlook = builder.getOutlook();
            this.creditWatch = builder.getCreditWatch();
        }

        @Override
        @RosettaAttribute(value="agency")
        public CreditRatingAgencyEnum getAgency() {
            return this.agency;
        }

        @Override
        @RosettaAttribute(value="notation")
        public FieldWithMetaString getNotation() {
            return this.notation;
        }

        @Override
        @RosettaAttribute(value="scale")
        public FieldWithMetaString getScale() {
            return this.scale;
        }

        @Override
        @RosettaAttribute(value="debt")
        public CreditRatingDebt getDebt() {
            return this.debt;
        }

        @Override
        @RosettaAttribute(value="outlook")
        public CreditRatingOutlookEnum getOutlook() {
            return this.outlook;
        }

        @Override
        @RosettaAttribute(value="creditWatch")
        public CreditRatingCreditWatchEnum getCreditWatch() {
            return this.creditWatch;
        }

        @Override
        public CreditNotation build() {
            return this;
        }

        @Override
        public CreditNotationBuilder toBuilder() {
            CreditNotationBuilder builder = CreditNotation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditNotationBuilder builder) {
            Optional.ofNullable(this.getAgency()).ifPresent(builder::setAgency);
            Optional.ofNullable(this.getNotation()).ifPresent(builder::setNotation);
            Optional.ofNullable(this.getScale()).ifPresent(builder::setScale);
            Optional.ofNullable(this.getDebt()).ifPresent(builder::setDebt);
            Optional.ofNullable(this.getOutlook()).ifPresent(builder::setOutlook);
            Optional.ofNullable(this.getCreditWatch()).ifPresent(builder::setCreditWatch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditNotation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.agency, (Object)_that.getAgency())) {
                return false;
            }
            if (!Objects.equals(this.notation, _that.getNotation())) {
                return false;
            }
            if (!Objects.equals(this.scale, _that.getScale())) {
                return false;
            }
            if (!Objects.equals(this.debt, _that.getDebt())) {
                return false;
            }
            if (!Objects.equals((Object)this.outlook, (Object)_that.getOutlook())) {
                return false;
            }
            return Objects.equals((Object)this.creditWatch, (Object)_that.getCreditWatch());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agency != null ? ((Object)((Object)this.agency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notation != null ? this.notation.hashCode() : 0);
            _result = 31 * _result + (this.scale != null ? this.scale.hashCode() : 0);
            _result = 31 * _result + (this.debt != null ? this.debt.hashCode() : 0);
            _result = 31 * _result + (this.outlook != null ? ((Object)((Object)this.outlook)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditWatch != null ? ((Object)((Object)this.creditWatch)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditNotation {agency=" + (Object)((Object)this.agency) + ", notation=" + this.notation + ", scale=" + this.scale + ", debt=" + this.debt + ", outlook=" + (Object)((Object)this.outlook) + ", creditWatch=" + (Object)((Object)this.creditWatch) + '}';
        }
    }

    public static interface CreditNotationBuilder
    extends CreditNotation,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateNotation();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getNotation();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateScale();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getScale();

        public CreditRatingDebt.CreditRatingDebtBuilder getOrCreateDebt();

        @Override
        public CreditRatingDebt.CreditRatingDebtBuilder getDebt();

        public CreditNotationBuilder setAgency(CreditRatingAgencyEnum var1);

        public CreditNotationBuilder setNotation(FieldWithMetaString var1);

        public CreditNotationBuilder setNotationValue(String var1);

        public CreditNotationBuilder setScale(FieldWithMetaString var1);

        public CreditNotationBuilder setScaleValue(String var1);

        public CreditNotationBuilder setDebt(CreditRatingDebt var1);

        public CreditNotationBuilder setOutlook(CreditRatingOutlookEnum var1);

        public CreditNotationBuilder setCreditWatch(CreditRatingCreditWatchEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("agency"), CreditRatingAgencyEnum.class, (Object)this.getAgency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("outlook"), CreditRatingOutlookEnum.class, (Object)this.getOutlook(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditWatch"), CreditRatingCreditWatchEnum.class, (Object)this.getCreditWatch(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notation"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getNotation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scale"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getScale(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("debt"), processor, CreditRatingDebt.CreditRatingDebtBuilder.class, this.getDebt(), new AttributeMeta[0]);
        }

        public CreditNotationBuilder prune();
    }
}

