/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.functions.FilterPartyRole;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import javax.inject.Inject;

@RosettaDataRule(value="TradeBarrierDerterminationAgent")
@ImplementedBy(value=Default.class)
public interface TradeBarrierDerterminationAgent
extends Validator<Trade> {
    public static final String NAME = "TradeBarrierDerterminationAgent";
    public static final String DEFINITION = "if partyRole -> role contains PartyRoleEnum -> BarrierDeterminationAgent then FilterPartyRole(partyRole, PartyRoleEnum -> BarrierDeterminationAgent) count <= 1";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradeBarrierDerterminationAgent {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradeBarrierDerterminationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeBarrierDerterminationAgent.DEFINITION);
        }
    }

    public static class Default
    implements TradeBarrierDerterminationAgent {
        @Inject
        protected FilterPartyRole filterPartyRole;

        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradeBarrierDerterminationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeBarrierDerterminationAgent.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradeBarrierDerterminationAgent failed.";
            }
            return ValidationResult.failure((String)TradeBarrierDerterminationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeBarrierDerterminationAgent.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BARRIER_DETERMINATION_AGENT))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)MapperC.of(this.filterPartyRole.evaluate(MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).getMulti(), (PartyRoleEnum)((Object)((Object)MapperS.of((Object)((Object)PartyRoleEnum.BARRIER_DETERMINATION_AGENT)).get())))).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

