/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.IndexTransitionInstruction;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="IndexTransitionInstructionPriceQuantity")
@ImplementedBy(value=Default.class)
public interface IndexTransitionInstructionPriceQuantity
extends Validator<IndexTransitionInstruction> {
    public static final String NAME = "IndexTransitionInstructionPriceQuantity";
    public static final String DEFINITION = "priceQuantity -> price -> priceType contains PriceTypeEnum -> InterestRate and priceQuantity -> observable -> rateOption exists and priceQuantity -> quantity is absent";

    public ValidationResult<IndexTransitionInstruction> validate(RosettaPath var1, IndexTransitionInstruction var2);

    public static class NoOp
    implements IndexTransitionInstructionPriceQuantity {
        @Override
        public ValidationResult<IndexTransitionInstruction> validate(RosettaPath path, IndexTransitionInstruction indexTransitionInstruction) {
            return ValidationResult.success((String)IndexTransitionInstructionPriceQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"IndexTransitionInstruction", (RosettaPath)path, (String)IndexTransitionInstructionPriceQuantity.DEFINITION);
        }
    }

    public static class Default
    implements IndexTransitionInstructionPriceQuantity {
        @Override
        public ValidationResult<IndexTransitionInstruction> validate(RosettaPath path, IndexTransitionInstruction indexTransitionInstruction) {
            ComparisonResult result = this.executeDataRule(indexTransitionInstruction);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)IndexTransitionInstructionPriceQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"IndexTransitionInstruction", (RosettaPath)path, (String)IndexTransitionInstructionPriceQuantity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition IndexTransitionInstructionPriceQuantity failed.";
            }
            return ValidationResult.failure((String)IndexTransitionInstructionPriceQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"IndexTransitionInstruction", (RosettaPath)path, (String)IndexTransitionInstructionPriceQuantity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(IndexTransitionInstruction indexTransitionInstruction) {
            try {
                ComparisonResult result = ExpressionOperators.contains((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("getValue", _f -> _f.getValue()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)indexTransitionInstruction).mapC("getPriceQuantity", _indexTransitionInstruction -> _indexTransitionInstruction.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

