/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.TimeZone;
import cdm.base.datetime.metafields.FieldWithMetaTimeZone;
import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ContractDetails;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.TradeMeta;
import cdm.product.collateral.Collateral;
import cdm.product.template.TradableProduct;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Trade", builder=TradeBuilderImpl.class, version="5.0.0")
public interface Trade
extends RosettaModelObject,
GlobalKey {
    public static final TradeMeta metaData = new TradeMeta();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    public FieldWithMetaDate getTradeDate();

    public FieldWithMetaTimeZone getTradeTime();

    public TradableProduct getTradableProduct();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public ExecutionDetails getExecutionDetails();

    public ContractDetails getContractDetails();

    public Date getClearedDate();

    public Collateral getCollateral();

    public List<? extends Account> getAccount();

    public MetaFields getMeta();

    public Trade build();

    public TradeBuilder toBuilder();

    public static TradeBuilder builder() {
        return new TradeBuilderImpl();
    }

    default public RosettaMetaData<? extends Trade> metaData() {
        return metaData;
    }

    default public Class<? extends Trade> getType() {
        return Trade.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("clearedDate"), Date.class, (Object)this.getClearedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradeTime"), processor, FieldWithMetaTimeZone.class, this.getTradeTime(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradableProduct"), processor, TradableProduct.class, this.getTradableProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractDetails"), processor, ContractDetails.class, this.getContractDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("account"), processor, Account.class, this.getAccount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class TradeBuilderImpl
    implements TradeBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected FieldWithMetaDate.FieldWithMetaDateBuilder tradeDate;
        protected FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder tradeTime;
        protected TradableProduct.TradableProductBuilder tradableProduct;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected ExecutionDetails.ExecutionDetailsBuilder executionDetails;
        protected ContractDetails.ContractDetailsBuilder contractDetails;
        protected Date clearedDate;
        protected Collateral.CollateralBuilder collateral;
        protected List<Account.AccountBuilder> account = new ArrayList<Account.AccountBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int _index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, _index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.tradeDate != null ? this.tradeDate : (this.tradeDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getTradeTime() {
            return this.tradeTime;
        }

        @Override
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getOrCreateTradeTime() {
            FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder result = this.tradeTime != null ? this.tradeTime : (this.tradeTime = FieldWithMetaTimeZone.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradableProduct")
        public TradableProduct.TradableProductBuilder getTradableProduct() {
            return this.tradableProduct;
        }

        @Override
        public TradableProduct.TradableProductBuilder getOrCreateTradableProduct() {
            TradableProduct.TradableProductBuilder result = this.tradableProduct != null ? this.tradableProduct : (this.tradableProduct = TradableProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="partyRole")
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int _index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails() {
            ExecutionDetails.ExecutionDetailsBuilder result = this.executionDetails != null ? this.executionDetails : (this.executionDetails = ExecutionDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        public ContractDetails.ContractDetailsBuilder getContractDetails() {
            return this.contractDetails;
        }

        @Override
        public ContractDetails.ContractDetailsBuilder getOrCreateContractDetails() {
            ContractDetails.ContractDetailsBuilder result = this.contractDetails != null ? this.contractDetails : (this.contractDetails = ContractDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        public Date getClearedDate() {
            return this.clearedDate;
        }

        @Override
        @RosettaAttribute(value="collateral")
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="account")
        public List<? extends Account.AccountBuilder> getAccount() {
            return this.account;
        }

        @Override
        public Account.AccountBuilder getOrCreateAccount(int _index) {
            if (this.account == null) {
                this.account = new ArrayList<Account.AccountBuilder>();
            }
            return (Account.AccountBuilder)this.getIndex(this.account, _index, () -> {
                Account.AccountBuilder newAccount = Account.builder();
                return newAccount;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public TradeBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier) {
            if (tradeIdentifier != null) {
                this.tradeIdentifier.add(tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier, int _idx) {
            this.getIndex(this.tradeIdentifier, _idx, () -> tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        public TradeBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        public TradeBuilder setTradeDate(FieldWithMetaDate tradeDate) {
            this.tradeDate = tradeDate == null ? null : tradeDate.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setTradeDateValue(Date tradeDate) {
            this.getOrCreateTradeDate().setValue(tradeDate);
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        public TradeBuilder setTradeTime(FieldWithMetaTimeZone tradeTime) {
            this.tradeTime = tradeTime == null ? null : tradeTime.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder setTradeTimeValue(TimeZone tradeTime) {
            this.getOrCreateTradeTime().setValue(tradeTime);
            return this;
        }

        @Override
        @RosettaAttribute(value="tradableProduct")
        public TradeBuilder setTradableProduct(TradableProduct tradableProduct) {
            this.tradableProduct = tradableProduct == null ? null : tradableProduct.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        public TradeBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        public TradeBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        public TradeBuilder setExecutionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails == null ? null : executionDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        public TradeBuilder setContractDetails(ContractDetails contractDetails) {
            this.contractDetails = contractDetails == null ? null : contractDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        public TradeBuilder setClearedDate(Date clearedDate) {
            this.clearedDate = clearedDate == null ? null : clearedDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        public TradeBuilder setCollateral(Collateral collateral) {
            this.collateral = collateral == null ? null : collateral.toBuilder();
            return this;
        }

        @Override
        public TradeBuilder addAccount(Account account) {
            if (account != null) {
                this.account.add(account.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addAccount(Account account, int _idx) {
            this.getIndex(this.account, _idx, () -> account.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addAccount(List<? extends Account> accounts) {
            if (accounts != null) {
                for (Account account : accounts) {
                    this.account.add(account.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="account")
        public TradeBuilder setAccount(List<? extends Account> accounts) {
            this.account = accounts == null ? new ArrayList<Account.AccountBuilder>() : (List)accounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public TradeBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public Trade build() {
            return new TradeImpl(this);
        }

        @Override
        public TradeBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeBuilder prune() {
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradeDate != null && !this.tradeDate.prune().hasData()) {
                this.tradeDate = null;
            }
            if (this.tradeTime != null && !this.tradeTime.prune().hasData()) {
                this.tradeTime = null;
            }
            if (this.tradableProduct != null && !this.tradableProduct.prune().hasData()) {
                this.tradableProduct = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.executionDetails != null && !this.executionDetails.prune().hasData()) {
                this.executionDetails = null;
            }
            if (this.contractDetails != null && !this.contractDetails.prune().hasData()) {
                this.contractDetails = null;
            }
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            this.account = this.account.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeDate() != null) {
                return true;
            }
            if (this.getTradeTime() != null && this.getTradeTime().hasData()) {
                return true;
            }
            if (this.getTradableProduct() != null && this.getTradableProduct().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExecutionDetails() != null && this.getExecutionDetails().hasData()) {
                return true;
            }
            if (this.getContractDetails() != null && this.getContractDetails().hasData()) {
                return true;
            }
            if (this.getClearedDate() != null) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            return this.getAccount() != null && this.getAccount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeBuilder o = (TradeBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeDate(), (RosettaModelObjectBuilder)o.getTradeDate(), this::setTradeDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeTime(), (RosettaModelObjectBuilder)o.getTradeTime(), this::setTradeTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradableProduct(), (RosettaModelObjectBuilder)o.getTradableProduct(), this::setTradableProduct);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDetails(), (RosettaModelObjectBuilder)o.getExecutionDetails(), this::setExecutionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContractDetails(), (RosettaModelObjectBuilder)o.getContractDetails(), this::setContractDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta(this.getAccount(), o.getAccount(), this::getOrCreateAccount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getClearedDate(), (Object)o.getClearedDate(), this::setClearedDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.tradeTime, _that.getTradeTime())) {
                return false;
            }
            if (!Objects.equals(this.tradableProduct, _that.getTradableProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.clearedDate, _that.getClearedDate())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeTime != null ? this.tradeTime.hashCode() : 0);
            _result = 31 * _result + (this.tradableProduct != null ? this.tradableProduct.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeBuilder {tradeIdentifier=" + this.tradeIdentifier + ", tradeDate=" + this.tradeDate + ", tradeTime=" + this.tradeTime + ", tradableProduct=" + this.tradableProduct + ", party=" + this.party + ", partyRole=" + this.partyRole + ", executionDetails=" + this.executionDetails + ", contractDetails=" + this.contractDetails + ", clearedDate=" + this.clearedDate + ", collateral=" + this.collateral + ", account=" + this.account + ", meta=" + this.meta + '}';
        }
    }

    public static class TradeImpl
    implements Trade {
        private final List<? extends TradeIdentifier> tradeIdentifier;
        private final FieldWithMetaDate tradeDate;
        private final FieldWithMetaTimeZone tradeTime;
        private final TradableProduct tradableProduct;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final ExecutionDetails executionDetails;
        private final ContractDetails contractDetails;
        private final Date clearedDate;
        private final Collateral collateral;
        private final List<? extends Account> account;
        private final MetaFields meta;

        protected TradeImpl(TradeBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeDate = Optional.ofNullable(builder.getTradeDate()).map(f -> f.build()).orElse(null);
            this.tradeTime = Optional.ofNullable(builder.getTradeTime()).map(f -> f.build()).orElse(null);
            this.tradableProduct = Optional.ofNullable(builder.getTradableProduct()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.executionDetails = Optional.ofNullable(builder.getExecutionDetails()).map(f -> f.build()).orElse(null);
            this.contractDetails = Optional.ofNullable(builder.getContractDetails()).map(f -> f.build()).orElse(null);
            this.clearedDate = builder.getClearedDate();
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.account = Optional.ofNullable(builder.getAccount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="tradeDate")
        public FieldWithMetaDate getTradeDate() {
            return this.tradeDate;
        }

        @Override
        @RosettaAttribute(value="tradeTime")
        public FieldWithMetaTimeZone getTradeTime() {
            return this.tradeTime;
        }

        @Override
        @RosettaAttribute(value="tradableProduct")
        public TradableProduct getTradableProduct() {
            return this.tradableProduct;
        }

        @Override
        @RosettaAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        public ExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        public ContractDetails getContractDetails() {
            return this.contractDetails;
        }

        @Override
        @RosettaAttribute(value="clearedDate")
        public Date getClearedDate() {
            return this.clearedDate;
        }

        @Override
        @RosettaAttribute(value="collateral")
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="account")
        public List<? extends Account> getAccount() {
            return this.account;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Trade build() {
            return this;
        }

        @Override
        public TradeBuilder toBuilder() {
            TradeBuilder builder = Trade.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getTradeTime()).ifPresent(builder::setTradeTime);
            Optional.ofNullable(this.getTradableProduct()).ifPresent(builder::setTradableProduct);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getExecutionDetails()).ifPresent(builder::setExecutionDetails);
            Optional.ofNullable(this.getContractDetails()).ifPresent(builder::setContractDetails);
            Optional.ofNullable(this.getClearedDate()).ifPresent(builder::setClearedDate);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getAccount()).ifPresent(builder::setAccount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            if (!Objects.equals(this.tradeTime, _that.getTradeTime())) {
                return false;
            }
            if (!Objects.equals(this.tradableProduct, _that.getTradableProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.clearedDate, _that.getClearedDate())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.account, _that.getAccount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeTime != null ? this.tradeTime.hashCode() : 0);
            _result = 31 * _result + (this.tradableProduct != null ? this.tradableProduct.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.clearedDate != null ? this.clearedDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trade {tradeIdentifier=" + this.tradeIdentifier + ", tradeDate=" + this.tradeDate + ", tradeTime=" + this.tradeTime + ", tradableProduct=" + this.tradableProduct + ", party=" + this.party + ", partyRole=" + this.partyRole + ", executionDetails=" + this.executionDetails + ", contractDetails=" + this.contractDetails + ", clearedDate=" + this.clearedDate + ", collateral=" + this.collateral + ", account=" + this.account + ", meta=" + this.meta + '}';
        }
    }

    public static interface TradeBuilder
    extends Trade,
    RosettaModelObjectBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate();

        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getOrCreateTradeTime();

        @Override
        public FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder getTradeTime();

        public TradableProduct.TradableProductBuilder getOrCreateTradableProduct();

        @Override
        public TradableProduct.TradableProductBuilder getTradableProduct();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails();

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails();

        public ContractDetails.ContractDetailsBuilder getOrCreateContractDetails();

        @Override
        public ContractDetails.ContractDetailsBuilder getContractDetails();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public Account.AccountBuilder getOrCreateAccount(int var1);

        public List<? extends Account.AccountBuilder> getAccount();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public TradeBuilder addTradeIdentifier(TradeIdentifier var1);

        public TradeBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public TradeBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public TradeBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        public TradeBuilder setTradeDate(FieldWithMetaDate var1);

        public TradeBuilder setTradeDateValue(Date var1);

        public TradeBuilder setTradeTime(FieldWithMetaTimeZone var1);

        public TradeBuilder setTradeTimeValue(TimeZone var1);

        public TradeBuilder setTradableProduct(TradableProduct var1);

        public TradeBuilder addParty(Party var1);

        public TradeBuilder addParty(Party var1, int var2);

        public TradeBuilder addParty(List<? extends Party> var1);

        public TradeBuilder setParty(List<? extends Party> var1);

        public TradeBuilder addPartyRole(PartyRole var1);

        public TradeBuilder addPartyRole(PartyRole var1, int var2);

        public TradeBuilder addPartyRole(List<? extends PartyRole> var1);

        public TradeBuilder setPartyRole(List<? extends PartyRole> var1);

        public TradeBuilder setExecutionDetails(ExecutionDetails var1);

        public TradeBuilder setContractDetails(ContractDetails var1);

        public TradeBuilder setClearedDate(Date var1);

        public TradeBuilder setCollateral(Collateral var1);

        public TradeBuilder addAccount(Account var1);

        public TradeBuilder addAccount(Account var1, int var2);

        public TradeBuilder addAccount(List<? extends Account> var1);

        public TradeBuilder setAccount(List<? extends Account> var1);

        public TradeBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("clearedDate"), Date.class, (Object)this.getClearedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradeTime"), processor, FieldWithMetaTimeZone.FieldWithMetaTimeZoneBuilder.class, this.getTradeTime(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradableProduct"), processor, TradableProduct.TradableProductBuilder.class, this.getTradableProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.ExecutionDetailsBuilder.class, this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractDetails"), processor, ContractDetails.ContractDetailsBuilder.class, this.getContractDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("account"), processor, Account.AccountBuilder.class, this.getAccount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public TradeBuilder prune();
    }
}

