/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CreditEventTypeEnum")
public enum CreditEventTypeEnum {
    BANKRUPTCY("Bankruptcy"),
    DISTRESSED_RATINGS_DOWNGRADE("DistressedRatingsDowngrade"),
    FAILURE_TO_PAY("FailureToPay"),
    FAILURE_TO_PAY_INTEREST("FailureToPayInterest"),
    FAILURE_TO_PAY_PRINCIPAL("FailureToPayPrincipal"),
    GOVERNMENTAL_INTERVENTION("GovernmentalIntervention"),
    IMPLIED_WRITEDOWN("ImpliedWritedown"),
    MATURITY_EXTENSION("MaturityExtension"),
    OBLIGATION_ACCELERATION("ObligationAcceleration"),
    OBLIGATION_DEFAULT("ObligationDefault"),
    REPUDIATION_MORATORIUM("RepudiationMoratorium"),
    RESTRUCTURING("Restructuring"),
    WRITEDOWN("Writedown");

    private static Map<String, CreditEventTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CreditEventTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private CreditEventTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CreditEventTypeEnum fromDisplayName(String name) {
        CreditEventTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CreditEventTypeEnum> map = new ConcurrentHashMap<String, CreditEventTypeEnum>();
        for (CreditEventTypeEnum instance : CreditEventTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

