/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Commodity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CommodityValueSource")
@ImplementedBy(value=Default.class)
public interface CommodityValueSource
extends Validator<Commodity> {
    public static final String NAME = "CommodityValueSource";
    public static final String DEFINITION = "if productTaxonomy exists then (productTaxonomy -> source exists and productTaxonomy -> value exists)";

    public ValidationResult<Commodity> validate(RosettaPath var1, Commodity var2);

    public static class NoOp
    implements CommodityValueSource {
        @Override
        public ValidationResult<Commodity> validate(RosettaPath path, Commodity commodity) {
            return ValidationResult.success((String)CommodityValueSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityValueSource.DEFINITION);
        }
    }

    public static class Default
    implements CommodityValueSource {
        @Override
        public ValidationResult<Commodity> validate(RosettaPath path, Commodity commodity) {
            ComparisonResult result = this.executeDataRule(commodity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CommodityValueSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityValueSource.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CommodityValueSource failed.";
            }
            return ValidationResult.failure((String)CommodityValueSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityValueSource.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Commodity commodity) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy()).map("getSource", taxonomy -> taxonomy.getSource())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy()).map("getValue", taxonomy -> taxonomy.getValue())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

