/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Commodity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CommodityOrdinalExists")
@ImplementedBy(value=Default.class)
public interface CommodityOrdinalExists
extends Validator<Commodity> {
    public static final String NAME = "CommodityOrdinalExists";
    public static final String DEFINITION = "if productTaxonomy -> value -> classification count > 1 then productTaxonomy -> value -> classification -> ordinal exists";

    public ValidationResult<Commodity> validate(RosettaPath var1, Commodity var2);

    public static class NoOp
    implements CommodityOrdinalExists {
        @Override
        public ValidationResult<Commodity> validate(RosettaPath path, Commodity commodity) {
            return ValidationResult.success((String)CommodityOrdinalExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityOrdinalExists.DEFINITION);
        }
    }

    public static class Default
    implements CommodityOrdinalExists {
        @Override
        public ValidationResult<Commodity> validate(RosettaPath path, Commodity commodity) {
            ComparisonResult result = this.executeDataRule(commodity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CommodityOrdinalExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityOrdinalExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CommodityOrdinalExists failed.";
            }
            return ValidationResult.failure((String)CommodityOrdinalExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityOrdinalExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Commodity commodity) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)MapperS.of((Object)commodity).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy()).map("getValue", taxonomy -> taxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getProductTaxonomy", productBase -> productBase.getProductTaxonomy()).map("getValue", taxonomy -> taxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

