/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.validation.datarule;

import cdm.base.math.NonNegativeStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

@RosettaDataRule(value="NonNegativeStepStepValue")
@ImplementedBy(value=Default.class)
public interface NonNegativeStepStepValue
extends Validator<NonNegativeStep> {
    public static final String NAME = "NonNegativeStepStepValue";
    public static final String DEFINITION = "stepValue >= 0.0";

    public ValidationResult<NonNegativeStep> validate(RosettaPath var1, NonNegativeStep var2);

    public static class NoOp
    implements NonNegativeStepStepValue {
        @Override
        public ValidationResult<NonNegativeStep> validate(RosettaPath path, NonNegativeStep nonNegativeStep) {
            return ValidationResult.success((String)NonNegativeStepStepValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonNegativeStep", (RosettaPath)path, (String)NonNegativeStepStepValue.DEFINITION);
        }
    }

    public static class Default
    implements NonNegativeStepStepValue {
        @Override
        public ValidationResult<NonNegativeStep> validate(RosettaPath path, NonNegativeStep nonNegativeStep) {
            ComparisonResult result = this.executeDataRule(nonNegativeStep);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)NonNegativeStepStepValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonNegativeStep", (RosettaPath)path, (String)NonNegativeStepStepValue.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition NonNegativeStepStepValue failed.";
            }
            return ValidationResult.failure((String)NonNegativeStepStepValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonNegativeStep", (RosettaPath)path, (String)NonNegativeStepStepValue.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(NonNegativeStep nonNegativeStep) {
            try {
                ComparisonResult result = ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)nonNegativeStep).map("getStepValue", _nonNegativeStep -> _nonNegativeStep.getStepValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

