/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundToPrecisionImpl
extends RoundToPrecision {
    @Override
    protected BigDecimal doEvaluate(BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
        if (value == null) {
            return null;
        }
        if (precision == null || roundingMode == null) {
            return value;
        }
        double scale = Math.pow(10.0, -1.0 * (double)precision.intValue());
        BigDecimal nearest = BigDecimal.valueOf(scale);
        return value.divide(nearest).setScale(0, this.toRoundingMode(roundingMode)).multiply(nearest);
    }

    private RoundingMode toRoundingMode(RoundingDirectionEnum roundingMode) {
        switch (roundingMode) {
            case UP: {
                return RoundingMode.UP;
            }
            case DOWN: {
                return RoundingMode.DOWN;
            }
            case NEAREST: {
                return RoundingMode.HALF_EVEN;
            }
        }
        throw new IllegalArgumentException("Unsupported RoundingDirectionEnum " + (Object)((Object)roundingMode));
    }
}

