/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.Frequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="FrequencyPositivePeriodMultiplier")
@ImplementedBy(value=Default.class)
public interface FrequencyPositivePeriodMultiplier
extends Validator<Frequency> {
    public static final String NAME = "FrequencyPositivePeriodMultiplier";
    public static final String DEFINITION = "periodMultiplier > 0";

    public ValidationResult<Frequency> validate(RosettaPath var1, Frequency var2);

    public static class NoOp
    implements FrequencyPositivePeriodMultiplier {
        @Override
        public ValidationResult<Frequency> validate(RosettaPath path, Frequency frequency) {
            return ValidationResult.success((String)FrequencyPositivePeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Frequency", (RosettaPath)path, (String)FrequencyPositivePeriodMultiplier.DEFINITION);
        }
    }

    public static class Default
    implements FrequencyPositivePeriodMultiplier {
        @Override
        public ValidationResult<Frequency> validate(RosettaPath path, Frequency frequency) {
            ComparisonResult result = this.executeDataRule(frequency);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)FrequencyPositivePeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Frequency", (RosettaPath)path, (String)FrequencyPositivePeriodMultiplier.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition FrequencyPositivePeriodMultiplier failed.";
            }
            return ValidationResult.failure((String)FrequencyPositivePeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Frequency", (RosettaPath)path, (String)FrequencyPositivePeriodMultiplier.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Frequency frequency) {
            try {
                ComparisonResult result = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)frequency).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

