# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['MasterAgreementSchedule']


class MasterAgreementSchedule(BaseDataClass):
  """
  The set of elections which specify a Master Agreement.
  """
  clause: List[MasterAgreementClause] = Field([], description="Clauses that have had elections made against them in this Master Agreement. There must be at least one clause defined in the agreement.")
  """
  Clauses that have had elections made against them in this Master Agreement. There must be at least one clause defined in the agreement.
  """
  @rosetta_condition
  def cardinality_clause(self):
    return check_cardinality(self.clause, 1, None)
  

from cdm.legaldocumentation.master.MasterAgreementClause import MasterAgreementClause

MasterAgreementSchedule.update_forward_refs()
