package cdm.product.template.validation.datarule;

import cdm.product.template.MultipleExercise;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("MultipleExerciseMaximumChoice")
@ImplementedBy(MultipleExerciseMaximumChoice.Default.class)
public interface MultipleExerciseMaximumChoice extends Validator<MultipleExercise> {
	
	String NAME = "MultipleExerciseMaximumChoice";
	String DEFINITION = "required choice maximumNotionalAmount, maximumNumberOfOptions";
	
	ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise);
	
	class Default implements MultipleExerciseMaximumChoice {
	
		@Override
		public ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise) {
			ComparisonResult result = executeDataRule(multipleExercise);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(MultipleExercise multipleExercise) {
			try {
				ComparisonResult result = choice(MapperS.of(multipleExercise), Arrays.asList("maximumNotionalAmount", "maximumNumberOfOptions"), ChoiceRuleValidationMethod.REQUIRED);
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MultipleExerciseMaximumChoice {
	
		@Override
		public ValidationResult<MultipleExercise> validate(RosettaPath path, MultipleExercise multipleExercise) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MultipleExercise", path, DEFINITION);
		}
	}
}
