package cdm.product.common.settlement.validation;

import cdm.product.common.settlement.PhysicalSettlementPeriod;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;

public class PhysicalSettlementPeriodTypeFormatValidator implements Validator<PhysicalSettlementPeriod> {

	@Override
	public ValidationResult<PhysicalSettlementPeriod> validate(RosettaPath path, PhysicalSettlementPeriod o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkNumber("businessDays", o.getBusinessDays(), empty(), of(0), empty(), empty()), 
				checkNumber("maximumBusinessDays", o.getMaximumBusinessDays(), empty(), of(0), empty(), empty())
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("PhysicalSettlementPeriod", ValidationType.TYPE_FORMAT, "PhysicalSettlementPeriod", path, "", error);
		}
		return success("PhysicalSettlementPeriod", ValidationType.TYPE_FORMAT, "PhysicalSettlementPeriod", path, "");
	}

}
