package cdm.observable.asset.validation;

import cdm.observable.asset.PriceSourceDisruption;
import cdm.observable.asset.SettlementRateOption;
import cdm.observable.asset.metafields.FieldWithMetaSettlementRateOptionEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class SettlementRateOptionValidator implements Validator<SettlementRateOption> {

	@Override
	public ValidationResult<SettlementRateOption> validate(RosettaPath path, SettlementRateOption o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("settlementRateOption", (FieldWithMetaSettlementRateOptionEnum) o.getSettlementRateOption() != null ? 1 : 0, 1, 1), 
				checkCardinality("priceSourceDisruption", (PriceSourceDisruption) o.getPriceSourceDisruption() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("SettlementRateOption", ValidationType.CARDINALITY, "SettlementRateOption", path, "", error);
		}
		return success("SettlementRateOption", ValidationType.CARDINALITY, "SettlementRateOption", path, "");
	}

}
