package cdm.legaldocumentation.master.validation;

import cdm.legaldocumentation.master.FxAdditionalTerms;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FxAdditionalTermsTypeFormatValidator implements Validator<FxAdditionalTerms> {

	@Override
	public ValidationResult<FxAdditionalTerms> validate(RosettaPath path, FxAdditionalTerms o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FxAdditionalTerms", ValidationType.TYPE_FORMAT, "FxAdditionalTerms", path, "", error);
		}
		return success("FxAdditionalTerms", ValidationType.TYPE_FORMAT, "FxAdditionalTerms", path, "");
	}

}
