package cdm.event.workflow.validation;

import cdm.event.workflow.Workflow;
import cdm.event.workflow.WorkflowStep;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class WorkflowValidator implements Validator<Workflow> {

	@Override
	public ValidationResult<Workflow> validate(RosettaPath path, Workflow o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("steps", (List<? extends WorkflowStep>) o.getSteps() == null ? 0 : ((List<? extends WorkflowStep>) o.getSteps()).size(), 1, 0)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Workflow", ValidationType.CARDINALITY, "Workflow", path, "", error);
		}
		return success("Workflow", ValidationType.CARDINALITY, "Workflow", path, "");
	}

}
