package cdm.event.common.validation;

import cdm.event.common.ScheduledTransfer;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ScheduledTransferTypeFormatValidator implements Validator<ScheduledTransfer> {

	@Override
	public ValidationResult<ScheduledTransfer> validate(RosettaPath path, ScheduledTransfer o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("ScheduledTransfer", ValidationType.TYPE_FORMAT, "ScheduledTransfer", path, "", error);
		}
		return success("ScheduledTransfer", ValidationType.TYPE_FORMAT, "ScheduledTransfer", path, "");
	}

}
