package cdm.event.common.validation;

import cdm.event.common.Exposure;
import cdm.event.position.metafields.ReferenceWithMetaPortfolioState;
import cdm.observable.asset.Money;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.time.ZonedDateTime;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class ExposureValidator implements Validator<Exposure> {

	@Override
	public ValidationResult<Exposure> validate(RosettaPath path, Exposure o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("tradePortfolio", (ReferenceWithMetaPortfolioState) o.getTradePortfolio() != null ? 1 : 0, 1, 1), 
				checkCardinality("aggregateValue", (Money) o.getAggregateValue() != null ? 1 : 0, 1, 1), 
				checkCardinality("calculationDateTime", (ZonedDateTime) o.getCalculationDateTime() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationDateTime", (ZonedDateTime) o.getValuationDateTime() != null ? 1 : 0, 1, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("Exposure", ValidationType.CARDINALITY, "Exposure", path, "", error);
		}
		return success("Exposure", ValidationType.CARDINALITY, "Exposure", path, "");
	}

}
