package cdm.event.common.validation;

import cdm.event.common.CreditEvent;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CreditEventTypeFormatValidator implements Validator<CreditEvent> {

	@Override
	public ValidationResult<CreditEvent> validate(RosettaPath path, CreditEvent o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CreditEvent", ValidationType.TYPE_FORMAT, "CreditEvent", path, "", error);
		}
		return success("CreditEvent", ValidationType.TYPE_FORMAT, "CreditEvent", path, "");
	}

}
